/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.InputField;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.InputFieldType;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewPlacement;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContext;
import org.netxms.nxmc.modules.objects.ObjectToolExecutor;
import org.netxms.nxmc.modules.objects.ObjectToolHandler;
import org.netxms.nxmc.modules.objects.ObjectToolsCache;
import org.netxms.nxmc.modules.objects.dialogs.ObjectToolInputDialog;
import org.netxms.nxmc.modules.objects.views.AgentActionResults;
import org.netxms.nxmc.modules.objects.views.LocalCommandResults;
import org.netxms.nxmc.modules.objects.views.MultiNodeCommandExecutor;
import org.netxms.nxmc.modules.objects.views.SSHCommandResults;
import org.netxms.nxmc.modules.objects.views.ServerCommandResults;
import org.netxms.nxmc.modules.objects.views.ServerScriptResults;
import org.netxms.nxmc.modules.objects.views.TableToolResults;
import org.netxms.nxmc.tools.ExternalWebBrowser;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ObjectToolExecutor {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectToolExecutor.class);

    private ObjectToolExecutor() {
    }

    public static boolean isToolAllowed(ObjectTool tool, Set<ObjectContext> objects) {
        if (tool.getToolType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (handler != null) {
            for (ObjectContext n : objects) {
                if (!n.isNode() || !handler.canExecuteOnNode((AbstractNode)n.object, tool)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isToolApplicable(ObjectTool tool, Set<ObjectContext> objects) {
        for (ObjectContext n : objects) {
            if (!tool.isApplicableForObject(n.object)) continue;
            return true;
        }
        return false;
    }

    public static void execute(Set<ObjectContext> allObjects, Set<ObjectContext> nodes, ObjectTool tool, ViewPlacement viewPlacement) {
        Map inputValues;
        HashSet<ObjectContext> objects = new HashSet<ObjectContext>();
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (tool.getToolType() != 0 || handler != null) {
            for (ObjectContext n : nodes) {
                if (tool.getToolType() == 0 && (!n.isNode() || !handler.canExecuteOnNode((AbstractNode)n.object, tool)) || !tool.isApplicableForObject(n.object)) continue;
                objects.add(n);
            }
        } else {
            return;
        }
        ArrayList<String> maskedFields = new ArrayList<String>();
        InputField[] fields = tool.getInputFields();
        if (fields.length > 0) {
            Arrays.sort(fields, new /* Unavailable Anonymous Inner Class!! */);
            inputValues = ObjectToolExecutor.readInputFields((String)tool.getDisplayName(), (InputField[])fields);
            if (inputValues == null) {
                return;
            }
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getType() != InputFieldType.PASSWORD) continue;
                maskedFields.add(fields[i].getName());
            }
        } else {
            inputValues = new HashMap(0);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private static Map<String, String> readInputFields(String title, InputField[] fields) {
        ObjectToolInputDialog dlg = new ObjectToolInputDialog(Registry.getMainWindow().getShell(), title, fields);
        if (dlg.open() != 0) {
            return null;
        }
        return dlg.getValues();
    }

    private static void executeOnNode(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, String expandedToolData, ViewPlacement viewPlacement) {
        switch (tool.getToolType()) {
            case 1: {
                ObjectToolExecutor.executeAgentAction((ObjectContext)node, (ObjectTool)tool, inputValues, maskedFields, (ViewPlacement)viewPlacement);
                break;
            }
            case 7: {
                ObjectToolExecutor.executeFileDownload((ObjectContext)node, (ObjectTool)tool, inputValues, (ViewPlacement)viewPlacement);
                break;
            }
            case 0: {
                ObjectToolExecutor.executeInternalTool((ObjectContext)node, (ObjectTool)tool);
                break;
            }
            case 5: {
                ObjectToolExecutor.executeLocalCommand((ObjectContext)node, (ObjectTool)tool, inputValues, (String)expandedToolData, (ViewPlacement)viewPlacement);
                break;
            }
            case 6: {
                ObjectToolExecutor.executeServerCommand((ObjectContext)node, (ObjectTool)tool, inputValues, maskedFields, (ViewPlacement)viewPlacement);
                break;
            }
            case 10: {
                ObjectToolExecutor.executeSshCommand((ObjectContext)node, (ObjectTool)tool, inputValues, (ViewPlacement)viewPlacement);
                break;
            }
            case 8: {
                ObjectToolExecutor.executeServerScript((ObjectContext)node, (ObjectTool)tool, inputValues, (ViewPlacement)viewPlacement);
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                ObjectToolExecutor.executeTableTool((ObjectContext)node, (ObjectTool)tool, (ViewPlacement)viewPlacement);
                break;
            }
            case 4: {
                ObjectToolExecutor.openURL((ObjectContext)node, (ObjectTool)tool, (String)expandedToolData, (ViewPlacement)viewPlacement);
            }
        }
    }

    private static void executeOnMultipleNodes(Set<ObjectContext> sourceObjects, Set<ObjectContext> nodes, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, List<String> expandedToolData, ViewPlacement viewPlacement) {
        Perspective p = viewPlacement.getPerspective();
        MultiNodeCommandExecutor view = new MultiNodeCommandExecutor(tool, sourceObjects, nodes, inputValues, maskedFields, expandedToolData);
        if (p != null) {
            p.addMainView((View)view, true, false);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)view);
            window.open();
        }
    }

    private static void executeTableTool(ObjectContext node, ObjectTool tool, ViewPlacement viewPlacement) {
        Perspective p = viewPlacement.getPerspective();
        TableToolResults view = new TableToolResults(node, tool);
        if (p != null) {
            p.addMainView((View)view, true, false);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)view);
            window.open();
        }
    }

    private static void executeAgentAction(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            Perspective p = viewPlacement.getPerspective();
            AgentActionResults view = new AgentActionResults(node, tool, inputValues, maskedFields);
            if (p != null) {
                p.addMainView((View)view, true, false);
            } else {
                PopOutViewWindow window = new PopOutViewWindow((View)view);
                window.open();
            }
        }
    }

    private static void executeServerCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, List<String> maskedFields, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            Perspective p = viewPlacement.getPerspective();
            ServerCommandResults view = new ServerCommandResults(node, tool, inputValues, maskedFields);
            if (p != null) {
                p.addMainView((View)view, true, false);
            } else {
                PopOutViewWindow window = new PopOutViewWindow((View)view);
                window.open();
            }
        }
    }

    private static void executeSshCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            Perspective p = viewPlacement.getPerspective();
            SSHCommandResults view = new SSHCommandResults(node, tool, inputValues, null);
            if (p != null) {
                p.addMainView((View)view, true, false);
            } else {
                PopOutViewWindow window = new PopOutViewWindow((View)view);
                window.open();
            }
        }
    }

    private static void executeServerScript(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        if ((tool.getFlags() & 2) == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            Perspective p = viewPlacement.getPerspective();
            ServerScriptResults view = new ServerScriptResults(node, tool, inputValues, null);
            if (p != null) {
                p.addMainView((View)view, true, false);
            } else {
                PopOutViewWindow window = new PopOutViewWindow((View)view);
                window.open();
            }
        }
    }

    private static void executeLocalCommand(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, String command, ViewPlacement viewPlacement) {
        if ((tool.getFlags() & 2) == 0) {
            7 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        } else {
            Perspective p = viewPlacement.getPerspective();
            LocalCommandResults view = new LocalCommandResults(node, tool, inputValues, null);
            if (p != null) {
                p.addMainView((View)view, true, false);
            } else {
                PopOutViewWindow window = new PopOutViewWindow((View)view);
                window.open();
            }
        }
    }

    private static void executeFileDownload(ObjectContext node, ObjectTool tool, Map<String, String> inputValues, ViewPlacement viewPlacement) {
        NXCSession session = Registry.getSession();
        String[] parameters = tool.getData().split("\u007f");
        String fileName = parameters[0];
        int maxFileSize = parameters.length > 0 ? Integer.parseInt(parameters[1]) : 0;
        boolean follow = parameters.length > 1 ? parameters[2].equals("true") : false;
        8 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    private static void executeInternalTool(ObjectContext node, ObjectTool tool) {
        ObjectToolHandler handler = ObjectToolsCache.findHandler((String)tool.getData());
        if (handler != null) {
            handler.execute((AbstractNode)node.object, tool);
        } else {
            MessageDialogHelper.openError((Shell)Registry.getMainWindow().getShell(), (String)i18n.tr("Error"), (String)i18n.tr("Cannot execute object tool: handler not defined"));
        }
    }

    private static void openURL(ObjectContext node, ObjectTool tool, String url, ViewPlacement viewPlacement) {
        if (node.isNode() && (tool.getFlags() & 0x80) != 0) {
            NXCSession session = Registry.getSession();
            9 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        } else {
            ExternalWebBrowser.open((String)url);
        }
    }
}

