/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objecttools.ObjectToolTableColumn;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditColumnDialog
extends Dialog {
    private static I18n i18n = LocalizationHelper.getI18n(EditColumnDialog.class);
    private final String[] formatNames = new String[]{i18n.tr("String"), i18n.tr("Integer"), i18n.tr("Float"), i18n.tr("IP Address"), i18n.tr("MAC Address"), i18n.tr("Interface Index")};
    private boolean create;
    private boolean snmpColumn;
    private ObjectToolTableColumn columnObject;
    private LabeledText name;
    private Combo format;
    private LabeledText data;
    private Button selectButton;

    public EditColumnDialog(Shell parentShell, boolean create, boolean snmpColumn, ObjectToolTableColumn columnObject) {
        super(parentShell);
        this.create = create;
        this.snmpColumn = snmpColumn;
        this.columnObject = columnObject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.create ? i18n.tr("Create Column") : i18n.tr("Edit Column"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(i18n.tr("Name"));
        this.name.setText(this.columnObject.getName());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.name.setLayoutData((Object)gd);
        this.format = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Format"), (Object)"WidgetHelper::default_layout_data");
        for (int i = 0; i < this.formatNames.length; ++i) {
            this.format.add(this.formatNames[i]);
        }
        this.format.select(this.columnObject.getFormat());
        Composite dataGroup = null;
        if (this.snmpColumn) {
            dataGroup = new Composite(dialogArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 2;
            layout.numColumns = 2;
            dataGroup.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            dataGroup.setLayoutData((Object)gd);
        }
        this.data = new LabeledText(this.snmpColumn ? dataGroup : dialogArea, 0);
        if (this.snmpColumn) {
            this.data.setLabel(i18n.tr("SNMP Object Identifier (OID)"));
            this.data.setText(this.columnObject.getSnmpOid());
        } else {
            this.data.setLabel(i18n.tr("Substring index (starting from 1)"));
            this.data.setText(Integer.toString(this.columnObject.getSubstringIndex()));
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.data.setLayoutData((Object)gd);
        if (this.snmpColumn) {
            this.selectButton = new Button(dataGroup, 8);
            this.selectButton.setText("...");
            gd = new GridData();
            gd.verticalAlignment = 1024;
            this.selectButton.setLayoutData((Object)gd);
            this.selectButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return dialogArea;
    }

    protected void okPressed() {
        if (this.snmpColumn) {
            this.columnObject.setSnmpOid(this.data.getText());
        } else {
            try {
                int n = Integer.parseInt(this.data.getText());
                this.columnObject.setSubstringIndex(n);
            }
            catch (NumberFormatException e) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Please enter valid substring number"));
                return;
            }
        }
        this.columnObject.setFormat(this.format.getSelectionIndex());
        this.columnObject.setName(this.name.getText().trim());
        super.okPressed();
    }
}

