/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.PassiveRackElementType;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.helpers.RackPassiveElementComparator;
import org.netxms.nxmc.modules.objects.propertypages.helpers.RackPassiveElementLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class PatchPanelSelectonDialog
extends Dialog {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_POSITION = 2;
    public static final int COLUMN_ORIENTATION = 3;
    private static final String CONFIG_PREFIX = "PatchPanelSelectonDialog";
    private I18n i18n = LocalizationHelper.getI18n(PatchPanelSelectonDialog.class);
    private SortableTableViewer viewer;
    private List<PassiveRackElement> passiveElements = new ArrayList();
    private long id;

    public PatchPanelSelectonDialog(Shell parentShell, Rack rack) {
        super(parentShell);
        for (PassiveRackElement el : rack.getPassiveElements()) {
            if (el.getType() != PassiveRackElementType.PATCH_PANEL) continue;
            this.passiveElements.add(el);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new FillLayout());
        String[] columnNames = new String[]{this.i18n.tr("Name"), this.i18n.tr("Type"), this.i18n.tr("Position"), this.i18n.tr("Orientation")};
        int[] columnWidths = new int[]{150, 100, 70, 30};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RackPassiveElementLabelProvider());
        this.viewer.setComparator((ViewerComparator)new RackPassiveElementComparator());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setInput((Object)this.passiveElements.toArray());
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select Patch Panel"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("PatchPanelSelectonDialog.cx", -1), settings.getAsInteger("PatchPanelSelectonDialog.cy", -1));
    }

    protected void okPressed() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Please select element from the list"));
            return;
        }
        PassiveRackElement element = (PassiveRackElement)selection.getFirstElement();
        this.id = element.getId();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("PatchPanelSelectonDialog.cx", size.x);
        settings.set("PatchPanelSelectonDialog.cy", size.y);
        super.buttonPressed(buttonId);
    }

    public long getPatchPanelId() {
        return this.id;
    }
}

