/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.base.InetAddressEx;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkService;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class NetworkServicePolling
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(NetworkServicePolling.class);
    private NetworkService service;
    private Combo serviceType;
    private LabeledText port;
    private LabeledText request;
    private LabeledText response;
    private LabeledText ipAddress;
    private ObjectSelector pollerNode;
    private Spinner pollCount;

    public NetworkServicePolling(AbstractObject object) {
        super(i18n.tr("Polling"), object);
    }

    public String getId() {
        return "networkServicePolling";
    }

    public int getPriority() {
        return 10;
    }

    public boolean isVisible() {
        return this.object instanceof NetworkService;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.service = (NetworkService)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.serviceType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Service type"), (Object)gd);
        this.serviceType.add(i18n.tr("User-defined"));
        this.serviceType.add(i18n.tr("SSH"));
        this.serviceType.add(i18n.tr("POP3"));
        this.serviceType.add(i18n.tr("SMTP"));
        this.serviceType.add(i18n.tr("FTP"));
        this.serviceType.add(i18n.tr("HTTP"));
        this.serviceType.add(i18n.tr("HTTPS"));
        this.serviceType.add(i18n.tr("Telnet"));
        this.serviceType.select(this.service.getServiceType());
        this.port = new LabeledText(dialogArea, 0);
        this.port.setLabel(i18n.tr("Port"));
        this.port.setText(Integer.toString(this.service.getPort()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.port.setLayoutData((Object)gd);
        this.ipAddress = new LabeledText(dialogArea, 0);
        this.ipAddress.setLabel("IP Address");
        if (this.service.getIpAddress().isValidAddress()) {
            this.ipAddress.setText(this.service.getIpAddress().getHostAddress());
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.ipAddress.setLayoutData((Object)gd);
        this.request = new LabeledText(dialogArea, 0);
        this.request.setLabel(i18n.tr("Request"));
        this.request.setText(this.service.getRequest());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.request.setLayoutData((Object)gd);
        this.response = new LabeledText(dialogArea, 0);
        this.response.setLabel(i18n.tr("Response"));
        this.response.setText(this.service.getResponse());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.response.setLayoutData((Object)gd);
        this.pollerNode = new ObjectSelector(dialogArea, 0, true);
        this.pollerNode.setLabel(i18n.tr("Poller node"));
        this.pollerNode.setEmptySelectionName(i18n.tr("<default>"));
        this.pollerNode.setObjectClass(AbstractNode.class);
        this.pollerNode.setObjectId(this.service.getPollerNode());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.pollerNode.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        this.pollCount = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)i18n.tr("Required poll count"), (int)0, (int)1000, (Object)gd);
        this.pollCount.setSelection(this.service.getPollCount());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        try {
            int ipPort = Integer.parseInt(this.port.getText());
            if (ipPort < 1 || ipPort > 65535) {
                throw new NumberFormatException();
            }
            md.setIpPort(ipPort);
        }
        catch (NumberFormatException e) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Please enter valid port number (1 .. 65535)"));
            return false;
        }
        md.setRequiredPolls(this.pollCount.getSelection());
        md.setServiceType(this.serviceType.getSelectionIndex());
        String addr = this.ipAddress.getText().trim();
        if (!addr.isEmpty()) {
            try {
                md.setIpAddress(new InetAddressEx(InetAddress.getByName(addr)));
            }
            catch (UnknownHostException e) {
                MessageDialogHelper.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Address validation error"));
                return false;
            }
        } else {
            md.setIpAddress(new InetAddressEx());
        }
        md.setRequest(this.request.getText());
        md.setResponse(this.response.getText());
        md.setPollerNode(this.pollerNode.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

