/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.helpers;

import java.net.InetAddress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.NXCSession;
import org.netxms.client.topology.OSPFNeighbor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.tools.ComparatorHelper;

public class OSPFNeighborComparator
extends ViewerComparator {
    final NXCSession session = Registry.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        OSPFNeighbor n1 = (OSPFNeighbor)e1;
        OSPFNeighbor n2 = (OSPFNeighbor)e2;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        switch (column) {
            case 6: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)n1.getAreaId(), (InetAddress)n2.getAreaId());
                break;
            }
            case 3: {
                result = Integer.compareUnsigned(n1.getInterfaceIndex(), n2.getInterfaceIndex());
                break;
            }
            case 4: {
                result = ComparatorHelper.compareStringsNatural((String)(n1.isVirtual() ? "" : this.session.getObjectName(n1.getInterfaceId())), (String)(n2.isVirtual() ? "" : this.session.getObjectName(n2.getInterfaceId())));
                break;
            }
            case 1: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)n1.getIpAddress(), (InetAddress)n2.getIpAddress());
                break;
            }
            case 2: {
                result = ComparatorHelper.compareStringsNatural((String)(n1.getNodeId() != 0L ? this.session.getObjectName(n1.getNodeId()) : ""), (String)(n2.getNodeId() != 0L ? this.session.getObjectName(n2.getNodeId()) : ""));
                break;
            }
            case 0: {
                result = ComparatorHelper.compareInetAddresses((InetAddress)n1.getRouterId(), (InetAddress)n2.getRouterId());
                break;
            }
            case 7: {
                result = n1.getState().getValue() - n2.getState().getValue();
                break;
            }
            case 5: {
                result = Boolean.compare(n1.isVirtual(), n2.isVirtual());
                break;
            }
            default: {
                result = 0;
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

