/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;

public class ObjectStatusWidget
extends Canvas
implements PaintListener {
    private AbstractObject object;

    public ObjectStatusWidget(Composite parent, AbstractObject object) {
        super(parent, 0);
        this.object = object;
        this.addPaintListener((PaintListener)this);
        this.setCursor(this.getDisplay().getSystemCursor(21));
        this.setToolTipText(this.getObjectDisplayName());
    }

    public void paintControl(PaintEvent e) {
        Rectangle rect = this.getClientArea();
        --rect.width;
        --rect.height;
        e.gc.setAntialias(1);
        e.gc.setTextAntialias(1);
        e.gc.setForeground(ThemeEngine.getForegroundColor((String)"StatusMap.Text"));
        e.gc.setLineWidth(1);
        e.gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.object.getStatus()));
        e.gc.setAlpha(127);
        e.gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        e.gc.setAlpha(255);
        e.gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 8, 8);
        String text = this.object instanceof AbstractNode ? this.getObjectDisplayName() + "\n" + ((AbstractNode)this.object).getPrimaryIP().getHostAddress() : this.getObjectDisplayName();
        rect.x += 4;
        rect.y += 4;
        rect.width -= 8;
        rect.height -= 8;
        e.gc.setClipping(rect);
        int h = e.gc.textExtent((String)text).y;
        e.gc.drawText(text, rect.x, rect.y + (rect.height - h) / 2, 3);
    }

    private String getObjectDisplayName() {
        return this.object.isInMaintenanceMode() ? this.object.getNameWithAlias() + " [Maintenance]" : this.object.getNameWithAlias();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        GC gc = new GC((Drawable)this.getShell());
        int h = gc.textExtent((String)"MMM\nMMM").y;
        gc.dispose();
        return new Point(160, h + 8);
    }

    public void updateObject(AbstractObject object) {
        this.object = object;
        this.redraw();
        this.setToolTipText(this.getObjectDisplayName());
    }
}

