/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.netxms.base.NXCommon;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.RackOrientation;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.configs.PassiveRackElement;
import org.netxms.client.objects.interfaces.HardwareEntity;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.imagelibrary.ImageUpdateListener;
import org.netxms.nxmc.modules.objects.views.AdHocChassisView;
import org.netxms.nxmc.modules.objects.widgets.ChassisWidget;
import org.netxms.nxmc.modules.objects.widgets.ObjectPopupDialog;
import org.netxms.nxmc.modules.objects.widgets.RackWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.ElementSelectionListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.FontTools;
import org.netxms.nxmc.tools.WidgetHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class RackWidget
extends Canvas
implements PaintListener,
ImageUpdateListener,
MouseListener,
MouseTrackListener {
    private static final double UNIT_WH_RATIO = 10.85;
    private static final int BORDER_WIDTH_RATIO = 15;
    private static final int FULL_UNIT_WIDTH = 482;
    private static final int FULL_UNIT_HEIGHT = 45;
    private static final int MARGIN_HEIGHT = 10;
    private static final int MARGIN_WIDTH = 5;
    private static final int UNIT_NUMBER_WIDTH = 30;
    private static final int TITLE_HEIGHT = 20;
    private static final int MAX_BORDER_WIDTH = 30;
    private static final String[] FONT_NAMES = new String[]{"Segoe UI", "Liberation Sans", "DejaVu Sans", "Verdana", "Arial"};
    private static final String[] SIDE_LABELS = new String[]{"Front", "Back"};
    private static Image imageDefaultTop = null;
    private static Image imageDefaultMiddle;
    private static Image imageDefaultBottom;
    private static Image imageDefaultRear;
    private static Image imagePatchPanel;
    private static Image imageFillerPanel;
    private static Image imageOrganiser;
    private static Image imagePDU;
    private Rack rack;
    private Font[] labelFonts;
    private Font[] titleFonts;
    private List<ObjectImage> objects = new ArrayList();
    private Object selectedObject = null;
    private Set<ElementSelectionListener> selectionListeners = new HashSet(0);
    private Object tooltipObject = null;
    private ObjectPopupDialog tooltipDialog = null;
    private RackOrientation side;
    private View view;

    private static void createImages() {
        if (imageDefaultTop != null) {
            return;
        }
        imageDefaultTop = ResourceManager.getImage((String)"icons/rack/rack-default-top.png");
        imageDefaultMiddle = ResourceManager.getImage((String)"icons/rack/rack-default-middle.png");
        imageDefaultBottom = ResourceManager.getImage((String)"icons/rack/rack-default-bottom.png");
        imageDefaultRear = ResourceManager.getImage((String)"icons/rack/rack-default-rear.png");
        imagePatchPanel = ResourceManager.getImage((String)"icons/rack/rack-patch-panel.png");
        imageOrganiser = ResourceManager.getImage((String)"icons/rack/rack-filler-panel.png");
        imageFillerPanel = ResourceManager.getImage((String)"icons/rack/rack-filler-panel.png");
        imagePDU = ResourceManager.getImage((String)"icons/rack/rack-pdu.png");
    }

    public RackWidget(Composite parent, int style, Rack rack, RackOrientation side, View view) {
        super(parent, style | 0x20000000);
        this.rack = rack;
        this.side = side == RackOrientation.FILL ? RackOrientation.FRONT : side;
        this.view = view;
        this.setBackground(ThemeEngine.getBackgroundColor((String)"Rack"));
        this.labelFonts = FontTools.getFonts((String[])FONT_NAMES, (int)6, (int)0, (int)16);
        this.titleFonts = FontTools.getFonts((String[])FONT_NAMES, (int)6, (int)1, (int)16);
        this.addPaintListener((PaintListener)this);
        this.addMouseListener((MouseListener)this);
        WidgetHelper.attachMouseTrackListener((Composite)this, (MouseTrackListener)this);
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
        RackWidget.createImages();
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Object getCurrentObject() {
        return this.selectedObject;
    }

    public void paintControl(PaintEvent e) {
        double dy;
        GC gc = e.gc;
        gc.setAntialias(1);
        WidgetHelper.setHighInterpolation((GC)gc);
        Rectangle rect = this.getClientArea();
        rect.x += 35;
        rect.y += 35;
        rect.height -= 45;
        double unitHeight = (double)rect.height / (double)this.rack.getHeight();
        int unitWidth = (int)(unitHeight * 10.85);
        int borderWidth = unitWidth / 15;
        if (borderWidth < 3) {
            borderWidth = 3;
        } else if (borderWidth > 30) {
            borderWidth = 30;
        }
        rect.height -= borderWidth + borderWidth / 2;
        rect.y += borderWidth / 2;
        unitHeight = (double)(rect.height - (borderWidth + 1) / 2 * 2) / (double)this.rack.getHeight();
        unitWidth = (int)(unitHeight * 10.85);
        rect.width = unitWidth + borderWidth * 2;
        rect.x += borderWidth / 2;
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.titleFonts, (String)SIDE_LABELS[0], (int)rect.width, (int)20));
        Point titleSize = gc.textExtent(SIDE_LABELS[this.side.getValue() - 1]);
        gc.drawText(SIDE_LABELS[this.side.getValue() - 1], rect.width / 2 - titleSize.x / 2 + 30 + 5, rect.y - 20 - 5 - borderWidth / 2);
        gc.setBackground(ThemeEngine.getBackgroundColor((String)"Rack.EmptySpace"));
        gc.fillRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setLineWidth(borderWidth);
        gc.setForeground(ThemeEngine.getForegroundColor((String)"Rack.Border"));
        gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 3, 3);
        gc.setBackground(ThemeEngine.getBackgroundColor((String)"Rack.Border"));
        gc.fillRectangle(rect.x + borderWidth * 2 - (borderWidth + 1) / 2, rect.y + rect.height, borderWidth * 2, (int)((double)borderWidth * 1.5));
        gc.fillRectangle(rect.x + rect.width - borderWidth * 3 - (borderWidth + 1) / 2, rect.y + rect.height, borderWidth * 2, (int)((double)borderWidth * 1.5));
        int[] unitBaselines = new int[this.rack.getHeight() + 1];
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.labelFonts, (String)"00", (int)30, (int)((int)unitHeight - 2)));
        gc.setForeground(ThemeEngine.getForegroundColor((String)"Rack"));
        gc.setBackground(ThemeEngine.getBackgroundColor((String)"Rack"));
        gc.setLineWidth(1);
        double d = dy = this.rack.isTopBottomNumbering() ? (double)rect.y + unitHeight + (double)((borderWidth + 1) / 2) : (double)(rect.y + rect.height - (borderWidth + 1) / 2);
        if (this.rack.isTopBottomNumbering()) {
            unitBaselines[0] = (int)(dy - unitHeight);
        }
        for (int u = 1; u <= this.rack.getHeight(); ++u) {
            int y = (int)dy;
            gc.drawLine(5, y, 30, y);
            String label = Integer.toString(u);
            Point textExtent = gc.textExtent(label);
            gc.drawText(label, 30 - textExtent.x, y - (int)unitHeight / 2 - textExtent.y / 2);
            if (this.rack.isTopBottomNumbering()) {
                unitBaselines[u] = y;
                dy += unitHeight;
                continue;
            }
            unitBaselines[u - 1] = y;
            dy -= unitHeight;
        }
        if (!this.rack.isTopBottomNumbering()) {
            unitBaselines[this.rack.getHeight()] = (int)dy;
        }
        this.objects.clear();
        for (PassiveRackElement c : this.rack.getPassiveElements()) {
            Rectangle r;
            Image image;
            int topLine;
            int bottomLine;
            if (c.getPosition() < 1 || c.getPosition() > this.rack.getHeight() || this.rack.isTopBottomNumbering() && c.getPosition() + c.getHeight() > this.rack.getHeight() + 1 || !this.rack.isTopBottomNumbering() && c.getPosition() - c.getHeight() < 0 || c.getOrientation() != this.side && c.getOrientation() != RackOrientation.FILL) continue;
            if (this.rack.isTopBottomNumbering()) {
                bottomLine = unitBaselines[c.getPosition() + c.getHeight() - 1];
                topLine = unitBaselines[c.getPosition() - 1];
            } else {
                bottomLine = unitBaselines[c.getPosition() - c.getHeight()];
                topLine = unitBaselines[c.getPosition()];
            }
            Rectangle unitRect = new Rectangle(rect.x + (borderWidth + 1) / 2, topLine + 1, rect.width - borderWidth, bottomLine - topLine);
            if (unitRect.width <= 0 || unitRect.height <= 0) break;
            this.objects.add(new ObjectImage(this, (Object)c, unitRect));
            if (c.getRearImage() != null && !c.getRearImage().equals(NXCommon.EMPTY_GUID) && this.side == RackOrientation.REAR) {
                image = ImageProvider.getInstance().getImage(c.getRearImage());
                r = image.getBounds();
                gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            if (c.getFrontImage() != null && !c.getFrontImage().equals(NXCommon.EMPTY_GUID) && this.side == RackOrientation.FRONT) {
                image = ImageProvider.getInstance().getImage(c.getFrontImage());
                r = image.getBounds();
                gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            switch (3.$SwitchMap$org$netxms$client$constants$PassiveRackElementType[c.getType().ordinal()]) {
                case 1: {
                    image = imagePatchPanel;
                    break;
                }
                case 2: {
                    image = imageOrganiser;
                    break;
                }
                case 3: {
                    image = imagePDU;
                    break;
                }
                default: {
                    image = imageFillerPanel;
                }
            }
            r = image.getBounds();
            int u = this.rack.isTopBottomNumbering() ? c.getPosition() : c.getPosition() - c.getHeight() + 1;
            int i = 0;
            while (i < c.getHeight()) {
                unitRect.y = unitBaselines[u];
                unitRect.height = unitBaselines[u - 1] - unitRect.y;
                gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                ++i;
                ++u;
            }
        }
        List units = this.rack.getUnits();
        for (HardwareEntity n : units) {
            int i;
            int u;
            Image imageBottom;
            Rectangle r;
            Image image;
            int topLine;
            int bottomLine;
            if (n.getRackPosition() < 1 || n.getRackPosition() > this.rack.getHeight() || this.rack.isTopBottomNumbering() && n.getRackPosition() + n.getRackHeight() > this.rack.getHeight() + 1 || !this.rack.isTopBottomNumbering() && n.getRackPosition() - n.getRackHeight() < 0 || n.getRackOrientation() != this.side && n.getRackOrientation() != RackOrientation.FILL) continue;
            if (this.rack.isTopBottomNumbering()) {
                bottomLine = unitBaselines[n.getRackPosition() + n.getRackHeight() - 1];
                topLine = unitBaselines[n.getRackPosition() - 1];
            } else {
                bottomLine = unitBaselines[n.getRackPosition() - n.getRackHeight()];
                topLine = unitBaselines[n.getRackPosition()];
            }
            Rectangle unitRect = new Rectangle(rect.x + (borderWidth + 1) / 2, topLine + 1, rect.width - borderWidth, bottomLine - topLine);
            if (unitRect.width <= 0 || unitRect.height <= 0) break;
            this.objects.add(new ObjectImage(this, (Object)n, unitRect));
            gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)n.getStatus()));
            gc.fillRectangle(unitRect.x - borderWidth + borderWidth / 4 + 1, unitRect.y + 1, borderWidth / 2 - 1, Math.min(borderWidth, (int)unitHeight - 2));
            if (n instanceof Chassis) {
                ChassisWidget.drawChassis((GC)gc, (Rectangle)unitRect, (Chassis)((Chassis)n), (RackOrientation)this.side, null);
                continue;
            }
            if (n.getRearRackImage() != null && !n.getRearRackImage().equals(NXCommon.EMPTY_GUID) && this.side == RackOrientation.REAR) {
                image = ImageProvider.getInstance().getImage(n.getRearRackImage());
                r = image.getBounds();
                gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            if (n.getFrontRackImage() != null && !n.getFrontRackImage().equals(NXCommon.EMPTY_GUID) && this.side == RackOrientation.FRONT) {
                image = ImageProvider.getInstance().getImage(n.getFrontRackImage());
                r = image.getBounds();
                gc.drawImage(image, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            Image imageTop = this.side == RackOrientation.REAR && n.getRackOrientation() == RackOrientation.FILL ? imageDefaultRear : imageDefaultTop;
            r = imageTop.getBounds();
            if (n.getRackHeight() == 1) {
                gc.drawImage(imageTop, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            Image imageMiddle = this.side == RackOrientation.REAR && n.getRackOrientation() == RackOrientation.FILL ? imageDefaultRear : imageDefaultMiddle;
            Image image2 = imageBottom = this.side == RackOrientation.REAR && n.getRackOrientation() == RackOrientation.FILL ? imageDefaultRear : imageDefaultBottom;
            if (this.rack.isTopBottomNumbering()) {
                unitRect.height = unitBaselines[n.getRackPosition()] - topLine;
                gc.drawImage(imageTop, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                r = imageMiddle.getBounds();
                u = n.getRackPosition() + 1;
                i = 1;
                while (i < n.getRackHeight() - 1) {
                    unitRect.y = unitBaselines[u - 1];
                    unitRect.height = unitBaselines[u] - unitRect.y;
                    gc.drawImage(imageMiddle, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                    ++i;
                    ++u;
                }
                r = imageBottom.getBounds();
                unitRect.y = unitBaselines[u - 1];
                unitRect.height = unitBaselines[u] - unitRect.y;
                gc.drawImage(imageBottom, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                continue;
            }
            unitRect.height = unitBaselines[n.getRackPosition() - 1] - topLine;
            gc.drawImage(imageTop, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
            r = imageMiddle.getBounds();
            u = n.getRackPosition() - 1;
            i = 1;
            while (i < n.getRackHeight() - 1) {
                unitRect.y = unitBaselines[u];
                unitRect.height = unitBaselines[u - 1] - unitRect.y;
                gc.drawImage(imageMiddle, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
                ++i;
                --u;
            }
            r = imageBottom.getBounds();
            unitRect.y = unitBaselines[u];
            unitRect.height = unitBaselines[u - 1] - unitRect.y;
            gc.drawImage(imageBottom, 0, 0, r.width, r.height, unitRect.x, unitRect.y, unitRect.width, unitRect.height);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (hHint == -1 && wHint == -1) {
            return new Point(10, 10);
        }
        if (hHint == -1) {
            int borderWidth = 32;
            return new Point(522 + borderWidth * 2 + borderWidth / 2, this.rack.getHeight() * 45 + 20 + borderWidth * 2 + 5 + 20);
        }
        double unitHeight = (double)hHint / (double)this.rack.getHeight();
        int unitWidth = (int)(unitHeight * 10.85);
        int borderWidth = unitWidth / 15;
        if (borderWidth < 3) {
            borderWidth = 3;
        } else if (borderWidth > 30) {
            borderWidth = 30;
        }
        unitWidth = (int)((double)(hHint - (borderWidth + 1) / 2 * 2 - 20) / (double)this.rack.getHeight() * 10.85);
        return new Point(unitWidth + 10 + 30 + borderWidth * 2 + borderWidth / 2, hHint);
    }

    public void imageUpdated(UUID guid) {
        boolean found = false;
        List units = this.rack.getUnits();
        for (HardwareEntity e : units) {
            if (!guid.equals(e.getFrontRackImage()) && !guid.equals(e.getRearRackImage())) continue;
            found = true;
            break;
        }
        if (found) {
            this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private Object getObjectAtPoint(Point p) {
        for (ObjectImage i : this.objects) {
            if (!i.contains(p)) continue;
            return i.getObject();
        }
        return null;
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!(this.selectedObject instanceof PassiveRackElement) && this.selectedObject instanceof Chassis) {
            this.view.openView((View)new AdHocChassisView(this.rack.getObjectId(), (Chassis)this.selectedObject));
        }
    }

    public void mouseDown(MouseEvent e) {
        if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != this.tooltipDialog.getShell()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
        this.tooltipObject = null;
        this.setCurrentObject(this.getObjectAtPoint(new Point(e.x, e.y)));
    }

    public void mouseUp(MouseEvent e) {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed() && e.display.getActiveShell() != this.tooltipDialog.getShell()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
        this.tooltipObject = null;
    }

    public void mouseHover(MouseEvent e) {
        Object object = this.getObjectAtPoint(new Point(e.x, e.y));
        if (object != null && (object != this.tooltipObject || this.tooltipDialog == null || this.tooltipDialog.getShell() == null || this.tooltipDialog.getShell().isDisposed())) {
            if (this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed()) {
                this.tooltipDialog.close();
            }
            this.tooltipObject = object;
            this.tooltipDialog = new ObjectPopupDialog(this.getShell(), object, this.toDisplay(e.x, e.y));
            this.tooltipDialog.open();
        } else if (object == null && this.tooltipDialog != null && this.tooltipDialog.getShell() != null && !this.tooltipDialog.getShell().isDisposed()) {
            this.tooltipDialog.close();
            this.tooltipDialog = null;
        }
    }

    public void addSelectionListener(ElementSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(ElementSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    private void setCurrentObject(Object o) {
        this.selectedObject = o;
        for (ElementSelectionListener l : this.selectionListeners) {
            l.objectSelected(this.selectedObject);
        }
    }

    public static Image getImageDefaultTop() {
        RackWidget.createImages();
        return imageDefaultTop;
    }

    public static Image getImageDefaultMiddle() {
        RackWidget.createImages();
        return imageDefaultMiddle;
    }

    public static Image getImageDefaultBottom() {
        RackWidget.createImages();
        return imageDefaultBottom;
    }

    public static Image getImageDefaultRear() {
        RackWidget.createImages();
        return imageDefaultRear;
    }
}

