/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.tools.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerConsoleListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.TextConsole;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class ServerConsole
extends View {
    private static final I18n i18n = LocalizationHelper.getI18n(ServerConsole.class);
    private NXCSession session = Registry.getSession();
    private ServerConsoleListener listener = new /* Unavailable Anonymous Inner Class!! */;
    private TextConsole console;
    private Text commandInput;
    private TextConsole.IOConsoleOutputStream outputStream = null;
    private boolean connected = false;
    private Action actionClearOutput;
    private Action actionScrollLock;

    public ServerConsole() {
        super(i18n.tr("Server Debug Console"), ResourceManager.getImageDescriptor((String)"icons/tool-views/server-debug-console.png"), "ServerConsole", false);
    }

    protected void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.console = new TextConsole(parent, 0);
        this.console.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputStream = this.console.newOutputStream();
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite commandArea = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        commandArea.setLayout((Layout)layout);
        commandArea.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(commandArea, 0);
        label.setText(i18n.tr("Command:"));
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.commandInput = new Text(commandArea, 2048);
        this.commandInput.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.commandInput.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
    }

    private void createActions() {
        this.actionClearOutput = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+L", (IAction)this.actionClearOutput);
        this.actionScrollLock = new /* Unavailable Anonymous Inner Class!! */;
        this.actionScrollLock.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/scroll-lock.png"));
        this.actionScrollLock.setChecked(false);
        this.addKeyBinding("SCROLLLOCK", (IAction)this.actionScrollLock);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionClearOutput);
        manager.add((IAction)this.actionScrollLock);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionClearOutput);
        manager.add((IAction)this.actionScrollLock);
    }

    public void refresh() {
        if (!this.connected) {
            this.connect();
        }
    }

    public void activate() {
        super.activate();
        this.connect();
    }

    public void deactivate() {
        this.disconnect();
        super.deactivate();
    }

    public void dispose() {
        this.disconnect();
        super.dispose();
    }

    public void setFocus() {
        if (!this.commandInput.isDisposed()) {
            this.commandInput.setFocus();
        }
    }

    private void connect() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void disconnect() {
        this.connected = false;
        this.session.removeConsoleListener(this.listener);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void sendCommand() {
        String command = this.commandInput.getText().trim();
        this.commandInput.setText("");
        if (command.isEmpty()) {
            return;
        }
        this.outputStream.safeWrite("\u001b[33;1;7m " + command + " \u001b[0m\r\n");
        if (this.connected) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else {
            this.outputStream.safeWrite("\u001b[31;1mNOT CONNECTED\u001b[0m\r\n");
        }
    }
}

