/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.views.helpers;

import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.views.helpers.BaseUserLabelProvider;
import org.netxms.nxmc.modules.users.views.helpers.UserLabelDecorator;
import org.xnap.commons.i18n.I18n;

public class DecoratingUserLabelProvider
extends DecoratingLabelProvider
implements ITableLabelProvider {
    private static final I18n i18n = LocalizationHelper.getI18n(DecoratingUserLabelProvider.class);
    public static final String[] AUTH_METHOD = new String[]{i18n.tr("Password"), i18n.tr("RADIUS"), i18n.tr("Certificate"), i18n.tr("Certificate or password"), i18n.tr("Certificate or RADIUS"), i18n.tr("LDAP")};

    public DecoratingUserLabelProvider() {
        super((ILabelProvider)new BaseUserLabelProvider(), (ILabelDecorator)new UserLabelDecorator());
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return columnIndex == 0 ? this.getImage(element) : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
            case 5: {
                if (!(element instanceof User)) {
                    return "";
                }
                try {
                    return AUTH_METHOD[((User)element).getAuthMethod().getValue()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return i18n.tr("Unknown");
                }
            }
            case 3: {
                return ((AbstractUserObject)element).getDescription();
            }
            case 2: {
                return element instanceof User ? ((User)element).getFullName() : null;
            }
            case 6: {
                return ((AbstractUserObject)element).getGuid().toString();
            }
            case 7: {
                return ((AbstractUserObject)element).getLdapDn();
            }
            case 0: {
                return ((AbstractUserObject)element).getName();
            }
            case 4: {
                return (((AbstractUserObject)element).getFlags() & 0x80) != 0 ? i18n.tr("LDAP") : i18n.tr("Local");
            }
            case 1: {
                return element instanceof User ? i18n.tr("User") : i18n.tr("Group");
            }
            case 8: {
                return element instanceof User ? (((User)element).getLastLogin().getTime() == 0L ? i18n.tr("Never") : DateFormatFactory.getDateTimeFormat().format(((User)element).getLastLogin())) : "";
            }
            case 9: {
                return ((AbstractUserObject)element).getCreationTime().getTime() == 0L ? "" : DateFormatFactory.getDateTimeFormat().format(((AbstractUserObject)element).getCreationTime());
            }
        }
        return null;
    }
}

