/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.BreakIterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.rap.rwt.widgets.WidgetUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.base.widgets.StyledText;
import org.netxms.nxmc.base.widgets.helpers.MsgProxyWidget;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.FittedString;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WidgetHelper {
    private static final Logger logger = LoggerFactory.getLogger(WidgetHelper.class);
    public static final int INNER_SPACING = 2;
    public static final int OUTER_SPACING = 4;
    public static final int DIALOG_WIDTH_MARGIN = 10;
    public static final int DIALOG_HEIGHT_MARGIN = 10;
    public static final int DIALOG_SPACING = 5;
    public static final int BUTTON_WIDTH_HINT = 90;
    public static final int WIDE_BUTTON_WIDTH_HINT = 120;
    public static final String DEFAULT_LAYOUT_DATA = "WidgetHelper::default_layout_data";
    private static final Pattern patternOnlyCharNum = Pattern.compile("[a-zA-Z0-9]+");
    private static final Pattern patternAllDotsAtEnd = Pattern.compile("[.]*$");
    private static final Pattern patternCharsAndNumbersAtEnd = Pattern.compile("[a-zA-Z0-9]*$");
    private static final Pattern patternCharsAndNumbersAtStart = Pattern.compile("^[a-zA-Z0-9]*");

    public static String getNewLineCharacters() {
        return SystemUtils.IS_OS_WINDOWS ? "\r\n" : "\n";
    }

    public static Text createLabeledText(Composite parent, int flags, int widthHint, String labelText, String initialText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != "WidgetHelper::default_layout_data") {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Text text = new Text(group, flags);
        if (initialText != null) {
            text.setText(initialText);
        }
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = widthHint;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static StyledText createLabeledStyledText(Composite parent, int flags, String labelText, String initialText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != "WidgetHelper::default_layout_data") {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        StyledText text = new StyledText(group, flags);
        if (initialText != null) {
            text.setText(initialText);
        }
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        return text;
    }

    public static Combo createLabeledCombo(Composite parent, int flags, String labelText, Object layoutData) {
        return WidgetHelper.createLabeledCombo((Composite)parent, (int)flags, (String)labelText, (Object)layoutData, null);
    }

    public static Combo createLabeledCombo(Composite parent, int flags, String labelText, Object layoutData, Color backgroundColor) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (backgroundColor != null) {
            group.setBackground(backgroundColor);
        }
        if (layoutData != "WidgetHelper::default_layout_data") {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        if (backgroundColor != null) {
            label.setBackground(backgroundColor);
        }
        Combo combo = new Combo(group, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    public static Spinner createLabeledSpinner(Composite parent, int flags, String labelText, int minVal, int maxVal, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != "WidgetHelper::default_layout_data") {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Spinner spinner = new Spinner(group, flags);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        spinner.setLayoutData((Object)gridData);
        spinner.setMinimum(minVal);
        spinner.setMaximum(maxVal);
        return spinner;
    }

    public static ColorSelector createLabeledColorSelector(Composite parent, String labelText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != "WidgetHelper::default_layout_data") {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        ColorSelector cs = new ColorSelector(group);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        cs.getButton().setLayoutData((Object)gridData);
        return cs;
    }

    public static Control createLabeledControl(Composite parent, int flags, WidgetFactory factory, String labelText, Object layoutData) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        if (layoutData != "WidgetHelper::default_layout_data") {
            group.setLayoutData(layoutData);
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            group.setLayoutData((Object)gridData);
        }
        Label label = new Label(group, 0);
        label.setText(labelText);
        Control widget = factory.createControl(group, flags);
        widget.setLayoutData((Object)new GridData(4, 4, true, true));
        return widget;
    }

    public static void saveColumnSettings(Table table, String prefix) {
        PreferenceStore settings = PreferenceStore.getInstance();
        TableColumn[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Object id = columns[i].getData("ID");
            if (id == null || !(id instanceof Integer)) {
                id = i;
            }
            int width = columns[i].getWidth();
            if ((Integer)id == columns.length - 1 && SystemUtils.IS_OS_LINUX) {
                try {
                    int oldWidth = settings.getAsInteger(prefix + "." + id + ".width", 0);
                    ScrollBar sb = table.getVerticalBar();
                    if (sb != null && oldWidth < width && width - oldWidth <= sb.getSize().y) {
                        width = oldWidth;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            settings.set(prefix + "." + id + ".width", width);
        }
    }

    public static void restoreColumnSettings(Table table, String prefix) {
        PreferenceStore settings = PreferenceStore.getInstance();
        TableColumn[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            try {
                int w;
                Object id = columns[i].getData("ID");
                if (id == null || !(id instanceof Integer)) {
                    id = i;
                }
                if ((w = settings.getAsInteger(prefix + "." + id + ".width", 0)) <= 0) continue;
                columns[i].setWidth(w);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void saveColumnSettings(Tree tree, String prefix) {
        PreferenceStore settings = PreferenceStore.getInstance();
        TreeColumn[] columns = tree.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Object id = columns[i].getData("ID");
            if (id == null || !(id instanceof Integer)) {
                id = i;
            }
            settings.set(prefix + "." + id + ".width", columns[i].getWidth());
        }
    }

    public static void restoreColumnSettings(Tree tree, String prefix) {
        PreferenceStore settings = PreferenceStore.getInstance();
        TreeColumn[] columns = tree.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            try {
                int w;
                Object id = columns[i].getData("ID");
                if (id == null || !(id instanceof Integer)) {
                    id = i;
                }
                if ((w = settings.getAsInteger(prefix + "." + id + ".width", 0)) <= 0) continue;
                columns[i].setWidth(w);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void saveTableViewerSettings(SortableTableViewer viewer, String prefix) {
        Table table = viewer.getTable();
        WidgetHelper.saveColumnSettings((Table)table, (String)prefix);
        TableColumn column = table.getSortColumn();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set(prefix + ".sortColumn", column != null ? (Integer)column.getData("ID") : -1);
        settings.set(prefix + ".sortDirection", table.getSortDirection());
    }

    public static void restoreTableViewerSettings(SortableTableViewer viewer, String prefix) {
        Table table = viewer.getTable();
        WidgetHelper.restoreColumnSettings((Table)table, (String)prefix);
        PreferenceStore settings = PreferenceStore.getInstance();
        try {
            table.setSortDirection(settings.getAsInteger(prefix + ".sortDirection", 128));
            int column = settings.getAsInteger(prefix + ".sortColumn", 0);
            if (column >= 0) {
                table.setSortColumn(viewer.getColumnById(column));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static void saveTreeViewerSettings(SortableTreeViewer viewer, String prefix) {
        Tree tree = viewer.getTree();
        WidgetHelper.saveColumnSettings((Tree)tree, (String)prefix);
        TreeColumn column = tree.getSortColumn();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set(prefix + ".sortColumn", column != null ? (Integer)column.getData("ID") : -1);
        settings.set(prefix + ".sortDirection", tree.getSortDirection());
    }

    public static void restoreTreeViewerSettings(SortableTreeViewer viewer, String prefix) {
        Tree tree = viewer.getTree();
        WidgetHelper.restoreColumnSettings((Tree)tree, (String)prefix);
        PreferenceStore settings = PreferenceStore.getInstance();
        tree.setSortDirection(settings.getAsInteger(prefix + ".sortDirection", 128));
        int column = settings.getAsInteger(prefix + ".sortColumn", 0);
        if (column >= 0) {
            tree.setSortColumn(viewer.getColumnById(column));
        }
    }

    public static void saveColumnViewerSettings(ColumnViewer viewer, String prefix) {
        if (viewer instanceof SortableTableViewer) {
            WidgetHelper.saveTableViewerSettings((SortableTableViewer)((SortableTableViewer)viewer), (String)prefix);
        } else if (viewer instanceof SortableTreeViewer) {
            WidgetHelper.saveTreeViewerSettings((SortableTreeViewer)((SortableTreeViewer)viewer), (String)prefix);
        }
    }

    public static void restoreColumnViewerSettings(ColumnViewer viewer, String prefix) {
        if (viewer instanceof SortableTableViewer) {
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)((SortableTableViewer)viewer), (String)prefix);
        } else if (viewer instanceof SortableTreeViewer) {
            WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)((SortableTreeViewer)viewer), (String)prefix);
        }
    }

    public static void copyToClipboard(String text) {
        Clipboard cb = new Clipboard(Display.getCurrent());
        TextTransfer transfer = TextTransfer.getInstance();
        cb.setContents(new Object[]{text != null ? text : ""}, new Transfer[]{transfer});
        cb.dispose();
    }

    public static void addStyledTextEditorActions(IMenuManager manager, StyledText control, boolean readOnly) {
    }

    public static int getBestFittingFontMultiline(GC gc, Font[] fonts, String text, int width, int height, int maxLineCount) {
        int first = 0;
        int last = fonts.length - 1;
        int curr = last / 2;
        int font = 0;
        while (last > first) {
            gc.setFont(fonts[curr]);
            if (WidgetHelper.fitStringToRect((GC)gc, (String)text, (int)width, (int)height, (int)maxLineCount)) {
                font = curr;
                first = curr + 1;
                curr = first + (last - first) / 2;
                continue;
            }
            last = curr - 1;
            curr = first + (last - first) / 2;
        }
        return font;
    }

    public static boolean fitStringToRect(GC gc, String text, int width, int height, int maxLineCount) {
        Point ext = gc.textExtent(text);
        if (ext.y > height) {
            return false;
        }
        if (ext.x <= width) {
            return true;
        }
        FittedString newString = WidgetHelper.fitStringToArea((GC)gc, (String)text, (int)width, (int)(maxLineCount > 0 ? Math.min(maxLineCount, height / ext.y) : height / ext.y));
        return newString.isCutted();
    }

    public static FittedString fitStringToArea(GC gc, String text, int width, int maxLineCount) {
        StringBuilder name = new StringBuilder("");
        int start = 0;
        boolean fit = true;
        int i = 0;
        while (start < text.length()) {
            String substr;
            if (i >= maxLineCount) {
                fit = false;
                break;
            }
            int nameL = gc.textExtent((String)substr).x;
            substr = text.substring(start);
            int numOfCharToLeave = (width - 6) / (nameL / substr.length());
            if (numOfCharToLeave >= substr.length()) {
                numOfCharToLeave = substr.length();
            }
            Object tmp = substr;
            while (gc.textExtent((String)tmp).x > width) {
                Matcher matcher;
                if ((matcher = patternOnlyCharNum.matcher((CharSequence)(tmp = substr.substring(0, --numOfCharToLeave)))).matches() || i + 1 == maxLineCount && numOfCharToLeave != substr.length()) {
                    Matcher matcherReplaceDot = patternAllDotsAtEnd.matcher((CharSequence)tmp);
                    tmp = matcherReplaceDot.replaceAll("");
                    tmp = (String)tmp + "...";
                    fit = false;
                    continue;
                }
                Matcher matcherRemoveCharsAfterSeparator = patternCharsAndNumbersAtEnd.matcher((CharSequence)tmp);
                tmp = matcherRemoveCharsAfterSeparator.replaceAll("");
                numOfCharToLeave = ((String)tmp).length();
            }
            name.append((String)tmp);
            if (i + 1 < maxLineCount && numOfCharToLeave != substr.length()) {
                name.append("\n");
            }
            Matcher matcherRemoveLineEnd = patternCharsAndNumbersAtStart.matcher(substr.substring(numOfCharToLeave - 1));
            numOfCharToLeave = substr.length() - matcherRemoveLineEnd.replaceAll("").length();
            start = start + numOfCharToLeave + 1;
            ++i;
        }
        return new FittedString(name.toString(), fit);
    }

    public static Font getBestFittingFont(GC gc, Font[] fonts, String text, int width, int height) {
        int first = 0;
        int last = fonts.length - 1;
        int curr = last / 2;
        Font font = null;
        while (last > first) {
            gc.setFont(fonts[curr]);
            Point ext = gc.textExtent(text);
            if (ext.x <= width && ext.y <= height) {
                font = fonts[curr];
                first = curr + 1;
                curr = first + (last - first) / 2;
                continue;
            }
            last = curr - 1;
            curr = first + (last - first) / 2;
        }
        if (font == null) {
            font = fonts[0];
        }
        return font;
    }

    public static Font getMatchingSizeFont(Font[] fonts, Font sourceFont) {
        float h = sourceFont.getFontData()[0].getHeight();
        for (int i = 0; i < fonts.length; ++i) {
            if ((float)fonts[i].getFontData()[0].getHeight() != h) continue;
            return fonts[i];
        }
        return null;
    }

    private static boolean validateTextInputInternal(Control control, String text, String label, TextFieldValidator validator, PreferencePage page) {
        if (!control.isEnabled()) {
            return true;
        }
        boolean ok = validator.validate(text);
        control.setBackground(ok ? null : ThemeEngine.getBackgroundColor((String)"TextInput.Error"));
        if (ok) {
            if (page != null) {
                page.setErrorMessage(null);
            }
        } else if (page != null) {
            page.setErrorMessage(validator.getErrorMessage(text, label));
        } else {
            MessageDialogHelper.openError((Shell)control.getShell(), (String)LocalizationHelper.getI18n(WidgetHelper.class).tr("Input Validation Error"), (String)validator.getErrorMessage(text, label));
        }
        return ok;
    }

    public static boolean validateTextInput(Text text, String label, TextFieldValidator validator, PreferencePage page) {
        return WidgetHelper.validateTextInputInternal((Control)text, (String)text.getText(), (String)label, (TextFieldValidator)validator, (PreferencePage)page);
    }

    public static boolean validateTextInput(LabeledText text, TextFieldValidator validator, PreferencePage page) {
        return WidgetHelper.validateTextInputInternal((Control)text.getTextControl(), (String)text.getText(), (String)text.getLabel(), (TextFieldValidator)validator, (PreferencePage)page);
    }

    public static int fontPixelsToPoints(Display device, int px) {
        return (int)Math.round((double)px * 72.0 / (double)device.getDPI().y);
    }

    public static int scaleTextPoints(Display device, int pt) {
        return (int)Math.round((double)pt * ((double)device.getDPI().y / 96.0));
    }

    public static int getTextWidth(Control control, String text) {
        return WidgetHelper.getTextExtent((Control)control, (String)text).x;
    }

    public static Point getTextExtent(Control control, String text) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        Point e = gc.textExtent(text);
        gc.dispose();
        return e;
    }

    public static Point getTextExtent(Control control, Font font, String text) {
        GC gc = new GC((Drawable)control);
        gc.setFont(font);
        Point e = gc.textExtent(text);
        gc.dispose();
        return e;
    }

    public static int getColumnIndexById(Table table, int id) {
        int index = -1;
        TableColumn[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].isDisposed() || (Integer)columns[i].getData("ID") != id) continue;
            index = i;
            break;
        }
        return index;
    }

    public static int getColumnIndexById(Tree tree, int id) {
        int index = -1;
        TreeColumn[] columns = tree.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].isDisposed() || (Integer)columns[i].getData("ID") != id) continue;
            index = i;
            break;
        }
        return index;
    }

    public static Point computeWrapSize(GC gc, String text, int wHint) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int saved = 0;
        int last = 0;
        int height = lineHeight;
        int maxWidth = 0;
        int loc = wb.first();
        while (loc != -1) {
            String word = text.substring(saved, loc);
            Point extent = gc.textExtent(word);
            if (extent.x > wHint) {
                saved = last;
                height += extent.y;
                word = text.substring(last, loc);
                extent = gc.textExtent(word);
            }
            maxWidth = Math.max(maxWidth, extent.x);
            last = loc;
            loc = wb.next();
        }
        if (maxWidth > wHint) {
            return WidgetHelper.computeWrapSize((GC)gc, (String)text, (int)maxWidth);
        }
        return new Point(maxWidth, height);
    }

    public static void paintWrapText(GC gc, String text, Rectangle bounds) {
        WidgetHelper.paintWrapText((GC)gc, (String)text, (Rectangle)bounds, (boolean)false);
    }

    public static void paintWrapText(GC gc, String text, Rectangle bounds, boolean underline) {
        BreakIterator wb = BreakIterator.getWordInstance();
        wb.setText(text);
        FontMetrics fm = gc.getFontMetrics();
        int lineHeight = fm.getHeight();
        int descent = 2;
        int saved = 0;
        int last = 0;
        int y = bounds.y;
        int width = bounds.width;
        int loc = wb.first();
        while (loc != -1) {
            String line = text.substring(saved, loc);
            Point extent = gc.textExtent(line);
            if (extent.x > width) {
                String prevLine = text.substring(saved, last);
                gc.drawText(prevLine, bounds.x, y, true);
                if (underline) {
                    Point prevExtent = gc.textExtent(prevLine);
                    int lineY = y + lineHeight - descent + 1;
                    gc.drawLine(bounds.x, lineY, bounds.x + prevExtent.x, lineY);
                }
                saved = last;
                y += lineHeight;
            }
            last = loc;
            loc = wb.next();
        }
        String lastLine = text.substring(saved, last);
        gc.drawText(lastLine, bounds.x, y, true);
        if (underline) {
            int lineY = y + lineHeight - descent + 1;
            Point lastExtent = gc.textExtent(lastLine);
            gc.drawLine(bounds.x, lineY, bounds.x + lastExtent.x, lineY);
        }
    }

    public static String escapeText(String text, boolean convertNl, boolean jsString) {
        StringBuffer sb = new StringBuffer();
        int textLength = text.length();
        block10: for (int i = 0; i < textLength; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block10;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block10;
                }
                case '\r': {
                    if (convertNl) continue block10;
                    sb.append(ch);
                    continue block10;
                }
                case '\n': {
                    sb.append(convertNl ? "<br>" : Character.valueOf(ch));
                    continue block10;
                }
                case '\'': {
                    sb.append(jsString ? "\\'" : Character.valueOf(ch));
                    continue block10;
                }
                case '\\': {
                    sb.append(jsString ? "\\\\" : Character.valueOf(ch));
                    continue block10;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static void attachMouseTrackListener(Composite control, MouseTrackListener listener) {
        WidgetUtil.registerDataKeys((String[])new String[]{"msgProxyWidget"});
        MsgProxyWidget proxy = (MsgProxyWidget)control.getData("msgProxyWidgetInternal");
        if (proxy == null) {
            proxy = new MsgProxyWidget(control);
            control.setData("msgProxyWidgetInternal", (Object)proxy);
            control.setData("msgProxyWidget", (Object)proxy.getRemoteObjectId());
        }
        proxy.setMouseTrackListener(listener);
        ClientListener clientListener = (ClientListener)Registry.getProperty((String)"MouseHoverListener");
        if (clientListener == null) {
            String script = WidgetHelper.loadResourceAsText((String)"js/hover.js");
            if (script == null) {
                return;
            }
            clientListener = new ClientListener(script);
            Registry.getInstance();
            Registry.setProperty((String)"MouseHoverListener", (Object)clientListener);
        }
        control.addListener(6, (Listener)clientListener);
        control.addListener(5, (Listener)clientListener);
        control.addListener(7, (Listener)clientListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadResourceAsText(String resource) {
        InputStream input = WidgetHelper.class.getClassLoader().getResourceAsStream(resource);
        if (input == null) {
            logger.error("Resource " + resource + " not found");
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            StringBuilder builder = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                builder.append(line);
                builder.append('\n');
                line = reader.readLine();
            }
            String string = builder.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("Exception while loading resource " + resource, (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                } else {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void setScrollBarIncrement(Scrollable scrollable, int direction, int increment) {
    }

    public static void setHighInterpolation(GC gc) {
    }

    public static void setFileDialogFilterExtensions(FileDialog fd, String[] extensions) {
    }

    public static void setFileDialogFilterNames(FileDialog fd, String[] names) {
    }

    public static void getFileDialogFileList(FileDialog fd, List<File> fileList) {
        String[] files = fd.getFileNames();
        if (files.length > 0) {
            for (int i = 0; i < files.length; ++i) {
                fileList.add(new File(files[i]));
            }
        }
    }

    public static void setControlCustomType(Control control, String type) {
        control.setData("org.eclipse.rap.rwt.customVariant", (Object)type);
    }

    public static void disableTabFolderSelectionBar(CTabFolder tabFolder) {
    }

    public static TransferData[] getAvailableTypes(Clipboard cb) {
        return new TransferData[0];
    }
}

