/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.imagelibrary.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.NXCommon;
import org.netxms.client.LibraryImage;
import org.netxms.ui.eclipse.imagelibrary.Activator;
import org.netxms.ui.eclipse.imagelibrary.Messages;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageUpdateListener;
import org.netxms.ui.eclipse.imagelibrary.views.helpers.ImageCategory;
import org.netxms.ui.eclipse.imagelibrary.views.helpers.ImageLibraryContentProvider;
import org.netxms.ui.eclipse.imagelibrary.views.helpers.ImageLibraryLabelProvider;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImagePreview;

public class ImageSelectionDialog
extends Dialog
implements ImageUpdateListener {
    private static final String SELECT_IMAGE_CY = "SelectImage.cy";
    private static final String SELECT_IMAGE_CX = "SelectImage.cx";
    private static final int DEFAULT_ID = 1025;
    private Map<String, ImageCategory> imageCategories = new HashMap<String, ImageCategory>();
    private TreeViewer viewer;
    private ImagePreview imagePreview;
    private LibraryImage image;
    private boolean allowDefault;

    public ImageSelectionDialog(Shell parentShell) {
        this(parentShell, false);
    }

    public ImageSelectionDialog(Shell parentShell, boolean allowDefault) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.allowDefault = allowDefault;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.ImageSelectionDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt(SELECT_IMAGE_CX), settings.getInt(SELECT_IMAGE_CY));
        }
        catch (NumberFormatException e) {
            newShell.setSize(700, 400);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TreeViewer(dialogArea, 67584);
        this.viewer.setContentProvider((IContentProvider)new ImageLibraryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ImageLibraryLabelProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String n1 = e1 instanceof LibraryImage ? ((LibraryImage)e1).getName() : ((ImageCategory)e1).getName();
                String n2 = e2 instanceof LibraryImage ? ((LibraryImage)e2).getName() : ((ImageCategory)e2).getName();
                return n1.compareToIgnoreCase(n2);
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.imagePreview = new ImagePreview(dialogArea, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 300;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.imagePreview.setLayoutData(gd);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ImageSelectionDialog.this.viewer.getSelection();
                LibraryImage image = !selection.isEmpty() && selection.getFirstElement() instanceof LibraryImage ? (LibraryImage)selection.getFirstElement() : null;
                ImageSelectionDialog.this.imagePreview.setImage(image);
                ImageSelectionDialog.this.getButton(0).setEnabled(image != null);
            }
        });
        ImageProvider.getInstance().addUpdateListener(this);
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageProvider.getInstance().removeUpdateListener(ImageSelectionDialog.this);
            }
        });
        this.refreshImages();
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof LibraryImage)) {
            return;
        }
        this.image = (LibraryImage)selection.getFirstElement();
        this.saveSettings();
        super.okPressed();
    }

    private void defaultPressed() {
        this.image = new LibraryImage();
        this.saveSettings();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (1025 == buttonId) {
            this.defaultPressed();
        }
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put(SELECT_IMAGE_CX, size.x);
        settings.put(SELECT_IMAGE_CY, size.y);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.allowDefault) {
            Messages.get();
            this.createButton(parent, 1025, Messages.ImageSelectionDialog_Default, false);
        }
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void refreshImages() {
        ImageProvider provider = ImageProvider.getInstance();
        List<LibraryImage> imageLibrary = provider.getImageLibrary();
        this.imageCategories.clear();
        for (LibraryImage image : imageLibrary) {
            ImageCategory category = this.imageCategories.get(image.getCategory());
            if (category == null) {
                category = new ImageCategory(image.getCategory());
                this.imageCategories.put(category.getName(), category);
            }
            category.addImage(image);
        }
        this.viewer.setInput(this.imageCategories);
    }

    public UUID getImageGuid() {
        return this.image == null ? NXCommon.EMPTY_GUID : this.image.getGuid();
    }

    public LibraryImage getImage() {
        return this.image;
    }

    @Override
    public void imageUpdated(UUID guid) {
        if (this.getShell().isDisposed()) {
            return;
        }
        final LibraryImage image = ImageProvider.getInstance().getLibraryImageObject(guid);
        if (image != null) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IStructuredSelection selection = (IStructuredSelection)ImageSelectionDialog.this.viewer.getSelection();
                    UUID selectedGuid = selection.size() == 1 && selection.getFirstElement() instanceof LibraryImage ? ((LibraryImage)selection.getFirstElement()).getGuid() : NXCommon.EMPTY_GUID;
                    ImageCategory category = ImageSelectionDialog.this.imageCategories.get(image.getCategory());
                    if (category == null) {
                        category = new ImageCategory(image.getCategory());
                        ImageSelectionDialog.this.imageCategories.put(category.getName(), category);
                    }
                    category.addImage(image);
                    ImageSelectionDialog.this.viewer.refresh();
                    if (selectedGuid.equals(image.getGuid())) {
                        ImageSelectionDialog.this.viewer.setSelection((ISelection)new StructuredSelection((Object)image));
                    }
                }
            });
        }
    }
}

