/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.dialogs.KeyValuePairEditDialog;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ElementLabelComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;
import org.netxms.ui.eclipse.widgets.helpers.KeyValuePairLabelProvider;

public class PersistentStorageView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.PersistentStorageView";
    private NXCSession session;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Map<String, String> pStorageSet = new HashMap<String, String>();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        String[] setColumnNames = new String[]{"Key", "Value"};
        int[] setColumnWidths = new int[]{200, 400};
        this.viewer = new SortableTableViewer(parent, setColumnNames, setColumnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new KeyValuePairLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = ((IStructuredSelection)PersistentStorageView.this.viewer.getSelection()).size();
                PersistentStorageView.this.actionEdit.setEnabled(size == 1);
                PersistentStorageView.this.actionDelete.setEnabled(size > 0);
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PersistentStorageView.this.editValue();
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.refresh();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                PersistentStorageView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionEdit);
        }
        if (selection.size() > 0) {
            mgr.add((IAction)this.actionDelete);
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionCreate);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                PersistentStorageView.this.refresh();
            }
        };
        this.actionCreate = new Action("&New...", SharedIcons.ADD_OBJECT){

            public void run() {
                PersistentStorageView.this.createValue();
            }
        };
        this.actionCreate.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.new_task");
        handlerService.activateHandler(this.actionCreate.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCreate));
        this.actionEdit = new Action("&Edit...", SharedIcons.EDIT){

            public void run() {
                PersistentStorageView.this.editValue();
            }
        };
        this.actionEdit.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.edit_task");
        handlerService.activateHandler(this.actionEdit.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionEdit));
        this.actionDelete = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                PersistentStorageView.this.deleteValue();
            }
        };
    }

    private void refresh() {
        new ConsoleJob("Loading persistent storage entries", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PersistentStorageView.this.pStorageSet = PersistentStorageView.this.session.getPersistentStorageList();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PersistentStorageView.this.viewer.setInput((this).PersistentStorageView.this.pStorageSet.entrySet());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load persistent storage entries";
            }
        }.start();
    }

    private void createValue() {
        final KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getSite().getShell(), null, null, true, true);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Creating persistent storage entry", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PersistentStorageView.this.session.setPersistentStorageValue(dlg.getAtributeName(), dlg.getAttributeValue());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PersistentStorageView.this.pStorageSet.put(dlg.getAtributeName(), dlg.getAttributeValue());
                        (this).PersistentStorageView.this.viewer.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot create persistent storage entry";
            }
        }.start();
    }

    private void deleteValue() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        final ArrayList<String> keys = new ArrayList<String>();
        for (Object o : selection.toList()) {
            keys.add((String)((Map.Entry)o).getKey());
        }
        new ConsoleJob("Deleting persistent storage entry", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (final String key : keys) {
                    PersistentStorageView.this.session.deletePersistentStorageValue(key);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).PersistentStorageView.this.pStorageSet.remove(key);
                            (this).PersistentStorageView.this.viewer.refresh();
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete persistent storage entry";
            }
        }.start();
    }

    private void editValue() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry attr = (Map.Entry)selection.getFirstElement();
        final KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getSite().getShell(), (String)attr.getKey(), (String)attr.getValue(), true, false);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Updating persistent storage entry", (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                PersistentStorageView.this.session.setPersistentStorageValue(dlg.getAtributeName(), dlg.getAttributeValue());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).PersistentStorageView.this.pStorageSet.put(dlg.getAtributeName(), dlg.getAttributeValue());
                        (this).PersistentStorageView.this.viewer.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot update persistent storage entry";
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }
}

