/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.widgets.Card;

public abstract class OverviewPageElement {
    private AbstractObject object = null;
    private Composite parent;
    private Card widget = null;
    private OverviewPageElement anchor;
    private ObjectTab objectTab;

    public OverviewPageElement(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        this.parent = parent;
        this.anchor = anchor;
        this.objectTab = objectTab;
    }

    public AbstractObject getObject() {
        return this.object;
    }

    public void setObject(AbstractObject object) {
        this.object = object;
        if (this.widget == null || this.widget.isDisposed()) {
            this.widget = new Card(this.parent, this.getTitle()){

                protected Control createClientArea(Composite parent) {
                    return OverviewPageElement.this.createClientArea(parent);
                }
            };
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.verticalAlignment = 128;
            this.widget.setLayoutData((Object)gd);
        }
        this.onObjectChange();
    }

    public void dispose() {
        if (this.widget != null && !this.widget.isDisposed()) {
            this.widget.dispose();
        }
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return true;
    }

    public void fixPlacement() {
        if (this.widget != null && !this.widget.isDisposed()) {
            if (this.anchor == null) {
                this.widget.moveAbove(null);
            } else {
                this.widget.moveBelow(this.anchor.getAnchorControl());
            }
        }
    }

    private Control getAnchorControl() {
        if (this.widget != null && !this.widget.isDisposed()) {
            return this.widget;
        }
        if (this.anchor != null) {
            return this.anchor.getAnchorControl();
        }
        return null;
    }

    protected Display getDisplay() {
        return this.widget != null && !this.widget.isDisposed() ? this.widget.getDisplay() : Display.getCurrent();
    }

    protected ObjectTab getObjectTab() {
        return this.objectTab;
    }

    protected abstract Control createClientArea(Composite var1);

    protected abstract void onObjectChange();

    protected abstract String getTitle();
}

