/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.events.AlarmCategory;
import org.netxms.ui.eclipse.alarmviewer.editors.AlarmCategoryEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class General
extends PropertyPage {
    private Text textName;
    private Text textDescription;
    private AlarmCategoryEditor editor;
    private AlarmCategory category;
    private NXCSession session;

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        this.editor = (AlarmCategoryEditor)this.getElement().getAdapter(AlarmCategoryEditor.class);
        this.category = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        WidgetHelper.createLabeledText((Composite)dialogArea, (int)2060, (int)-1, (String)"Category ID", (String)Long.toString(this.category.getId()), (Object)"WidgetHelper::default_layout_data");
        this.textName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2052, (int)-1, (String)"Category name", (String)this.category.getName(), (Object)"WidgetHelper::default_layout_data");
        this.textDescription = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2050, (int)-1, (String)"Description", (String)this.category.getDescription(), (Object)"WidgetHelper::default_layout_data");
        this.textDescription.setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 100;
        gd.verticalAlignment = 4;
        this.textDescription.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        String newName = this.textName.getText();
        String newDescription = this.textDescription.getText();
        if (newName.equals("")) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Category name cannot be empty!");
            return false;
        }
        if (newName.equals(this.category.getName()) && newDescription.equals(this.category.getDescription())) {
            return true;
        }
        if (!newName.equals(this.category.getName())) {
            AlarmCategory c = this.session.findAlarmCategoryByName(newName);
            if (c != null) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Category name already exists!");
                return false;
            }
            this.category.setName(newName);
        }
        this.category.setDescription(newDescription);
        this.editor.modify();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

