/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.actions;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ExportDashboard
implements IObjectActionDelegate {
    private Dashboard dashboard = null;
    private IWorkbenchPart wbPart = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.wbPart = targetPart;
    }

    public void run(IAction action) {
        if (this.dashboard == null) {
            return;
        }
        FileDialog dlg = new FileDialog(this.wbPart.getSite().getShell(), 8192);
        Messages.get();
        dlg.setText(Messages.ExportDashboard_SelectFile);
        dlg.setFileName(String.valueOf(this.dashboard.getObjectName()) + ".xml");
        dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.ExportDashboard_XMLFiles;
        Messages.get();
        stringArray[1] = Messages.ExportDashboard_AllFiles;
        dlg.setFilterNames(stringArray);
        final String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        final HashSet<Long> objects = new HashSet<Long>();
        final HashMap<Long, Long> items = new HashMap<Long, Long>();
        final StringBuilder xml = new StringBuilder("<dashboard>\n\t<name>");
        xml.append(this.dashboard.getObjectName());
        xml.append("</name>\n\t<columns>");
        xml.append(this.dashboard.getNumColumns());
        xml.append("</columns>\n\t<flags>");
        xml.append(this.dashboard.getFlags());
        xml.append("</flags>\n\t<autoBindFlags>");
        xml.append(this.dashboard.getAutoBindFlags());
        xml.append("</autoBindFlags>\n\t<autoBindFilter>");
        xml.append(this.dashboard.getAutoBindFilter().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;"));
        xml.append("</autoBindFilter>\n\t<elements>\n");
        for (DashboardElement e : this.dashboard.getElements()) {
            xml.append("\t\t<dashboardElement>\n\t\t\t<type>");
            xml.append(e.getType());
            xml.append("</type>\n");
            xml.append(e.getLayout());
            xml.append('\n');
            xml.append(e.getData());
            xml.append("\n\t\t</dashboardElement>\n");
            DashboardElementConfig config = (DashboardElementConfig)Platform.getAdapterManager().getAdapter((Object)e, DashboardElementConfig.class);
            if (config == null) continue;
            objects.addAll(config.getObjects());
            items.putAll(config.getDataCollectionItems());
        }
        xml.append("\t</elements>\n");
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.ExportDashboard_JobTitle, this.wbPart, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                xml.append("\t<objectMap>\n");
                for (Long id : objects) {
                    AbstractObject o = session.findObjectById(id.longValue());
                    if (o == null) continue;
                    xml.append("\t\t<object id=\"");
                    xml.append(id);
                    xml.append("\" class=\"");
                    xml.append(o.getObjectClass());
                    xml.append("\">");
                    xml.append(o.getObjectName());
                    xml.append("</object>\n");
                }
                xml.append("\t</objectMap>\n\t<dciMap>\n");
                ArrayList<Long> nodeList = new ArrayList<Long>();
                ArrayList<Long> dciList = new ArrayList<Long>();
                for (Map.Entry dci : items.entrySet()) {
                    if ((Long)dci.getKey() == 0L || (Long)dci.getValue() == 0L) continue;
                    dciList.add((Long)dci.getKey());
                    nodeList.add((Long)dci.getValue());
                }
                Map names = session.dciIdsToNames(nodeList, dciList);
                int i = 0;
                while (i < names.size()) {
                    xml.append("\t\t<dci id=\"");
                    xml.append(dciList.get(i));
                    xml.append("\" node=\"");
                    xml.append(nodeList.get(i));
                    xml.append("\">");
                    xml.append((String)names.get(dciList.get(i)));
                    xml.append("</dci>\n");
                    ++i;
                }
                xml.append("\t</dciMap>\n</dashboard>\n");
                try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");){
                    out.write(xml.toString());
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ExportDashboard_ErrorText;
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.dashboard = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof Dashboard ? (Dashboard)obj : null;
        action.setEnabled(this.dashboard != null);
    }
}

