/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.netxms.nxmc.base.views.NavigationView;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.PerspectiveConfiguration;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.services.ToolsPerspectiveElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ToolsPerspective
extends Perspective {
    private static final Logger logger = LoggerFactory.getLogger(ToolsPerspective.class);
    private static final I18n i18n = LocalizationHelper.getI18n(ToolsPerspective.class);
    private List<ToolsPerspectiveElement> elements = new ArrayList();
    private ToolsPerspectiveElement previousSelectedElement = null;
    private NavigationView navigationView;

    public ToolsPerspective() {
        super("Tools", i18n.tr("Tools"), ResourceManager.getImage((String)"icons/perspective-tools.png"));
        ServiceLoader<ToolsPerspectiveElement> loader = ServiceLoader.load(ToolsPerspectiveElement.class, this.getClass().getClassLoader());
        for (ToolsPerspectiveElement e : loader) {
            logger.debug("Adding tools element " + e.getName());
            this.elements.add(e);
        }
        this.elements.sort(new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void configurePerspective(PerspectiveConfiguration configuration) {
        super.configurePerspective(configuration);
        configuration.hasNavigationArea = true;
        configuration.multiViewNavigationArea = false;
        configuration.multiViewMainArea = false;
        configuration.hasSupplementalArea = false;
        configuration.priority = 200;
    }

    protected void configureViews() {
        this.navigationView = new /* Unavailable Anonymous Inner Class!! */;
        this.addNavigationView(this.navigationView);
    }

    protected void navigationSelectionChanged(IStructuredSelection selection) {
        ToolsPerspectiveElement currentElement = (ToolsPerspectiveElement)selection.getFirstElement();
        if (this.previousSelectedElement == currentElement) {
            return;
        }
        if (currentElement != null) {
            this.setMainView(currentElement.createView());
        } else {
            this.setMainView(null);
        }
        this.previousSelectedElement = currentElement;
    }
}

