/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.events.Alarm;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlarmNotifier {
    public static final String[] SEVERITY_TEXT = new String[]{"NORMAL", "WARNING", "MINOR", "MAJOR", "CRITICAL", "REMINDER"};
    private static I18n i18n = LocalizationHelper.getI18n(AlarmNotifier.class);
    private static Logger logger = LoggerFactory.getLogger(AlarmNotifier.class);
    private static SessionListener listener = null;
    private static Map<Long, Integer> alarmStates = new HashMap();
    private static int outstandingAlarms = 0;
    private static long lastReminderTime = 0L;
    private static NXCSession session;
    private static PreferenceStore ps;
    private static File soundFilesDirectory;
    private static LinkedBlockingQueue<String> soundQueue;

    public static void init(NXCSession session) {
        AlarmNotifier.session = session;
        ps = PreferenceStore.getInstance();
        soundFilesDirectory = new File(Registry.getStateDir(), "sounds");
        if (!soundFilesDirectory.isDirectory()) {
            soundFilesDirectory.mkdirs();
        }
        AlarmNotifier.checkSounds();
        lastReminderTime = System.currentTimeMillis();
        try {
            HashMap alarms = session.getAlarms();
            for (Alarm a : alarms.values()) {
                alarmStates.put(a.getId(), a.getState());
                if (a.getState() != 0) continue;
                ++outstandingAlarms;
            }
            logger.info(String.format("Received %d alarms from server (%d outstanding)", alarms.size(), outstandingAlarms));
        }
        catch (Exception e) {
            logger.error("Exception while initializing alarm notifier", (Throwable)e);
        }
        listener = new /* Unavailable Anonymous Inner Class!! */;
        session.addListener(listener);
        Thread reminderThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "AlarmReminderThread");
        reminderThread.setDaemon(true);
        reminderThread.start();
        Thread playerThread = new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */, "AlarmSoundPlayer");
        playerThread.setDaemon(true);
        playerThread.start();
    }

    private static void checkSounds() {
        for (String s : SEVERITY_TEXT) {
            AlarmNotifier.getSoundAndDownloadIfRequired((String)s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSoundAndDownloadIfRequired(String severity) {
        String soundName;
        block12: {
            soundName = ps.getAsString("AlarmNotifier.Sound." + severity);
            if (soundName == null || soundName.isEmpty()) {
                return null;
            }
            if (!AlarmNotifier.isSoundFileExist((String)soundName)) {
                try {
                    File fileContent = session.downloadFileFromServer(soundName);
                    if (fileContent != null) {
                        FileInputStream src = null;
                        FileOutputStream dest = null;
                        try {
                            src = new FileInputStream(fileContent);
                            File f = new File(soundFilesDirectory, soundName);
                            f.createNewFile();
                            dest = new FileOutputStream(f);
                            FileChannel fcSrc = src.getChannel();
                            dest.getChannel().transferFrom(fcSrc, 0L, fcSrc.size());
                            break block12;
                        }
                        catch (IOException e) {
                            logger.error("Cannot copy sound file", (Throwable)e);
                            break block12;
                        }
                        finally {
                            if (src != null) {
                                src.close();
                            }
                            if (dest != null) {
                                dest.close();
                            }
                        }
                    }
                    logger.error("Cannot download sound file " + soundName + " from server");
                    soundName = null;
                }
                catch (Exception e) {
                    soundName = null;
                    ps.set("AlarmNotifier.Sound." + severity, "");
                    Display.getDefault().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
        }
        return soundName;
    }

    private static boolean isSoundFileExist(String name) {
        if (name.isEmpty()) {
            return true;
        }
        File f = new File(soundFilesDirectory, name);
        return f.isFile();
    }

    public static void stop() {
        NXCSession session = Registry.getSession();
        if (session != null && listener != null) {
            session.removeListener(listener);
        }
    }

    public static boolean isGlobalSoundEnabled() {
        return !ps.getAsBoolean("AlarmNotifier.LocalSound", false);
    }

    public static void playSounOnAlarm(Alarm alarm) {
        try {
            soundQueue.offer(SEVERITY_TEXT[alarm.getCurrentSeverity().getValue()]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.error("Invalid alarm severity", (Throwable)e);
        }
    }

    private static void processNewAlarm(Alarm alarm) {
        Integer state = (Integer)alarmStates.get(alarm.getId());
        if (state != null && state == 0) {
            --outstandingAlarms;
        }
        alarmStates.put(alarm.getId(), alarm.getState());
        if (alarm.getState() != 0) {
            return;
        }
        if (!ps.getAsBoolean("AlarmNotifier.LocalSound", false)) {
            AlarmNotifier.playSounOnAlarm((Alarm)alarm);
        }
        if (outstandingAlarms == 0) {
            lastReminderTime = System.currentTimeMillis();
        }
        ++outstandingAlarms;
    }

    static {
        soundQueue = new LinkedBlockingQueue(4);
    }
}

