/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.TableValueConfig;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TableValue
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(TableValue.class);
    private TableValueConfig config;
    private DciSelector dciSelector;
    private TitleConfigurator title;
    private Spinner refreshRate;

    public TableValue(DashboardElementConfig elementConfig) {
        super(i18n.tr("Table Value"), elementConfig);
    }

    public String getId() {
        return "alarm-viewer";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof TableValueConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (TableValueConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.title.setLayoutData((Object)gd);
        this.dciSelector = new DciSelector(dialogArea, 0, true);
        this.dciSelector.setLabel(i18n.tr("Table DCI"));
        this.dciSelector.setDcObjectType(2);
        this.dciSelector.setDciId(this.config.getObjectId(), this.config.getDciId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.dciSelector.setLayoutData((Object)gd);
        gd = new GridData();
        gd.verticalAlignment = 128;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshRate = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)i18n.tr("Refresh interval (seconds)"), (int)1, (int)10000, (Object)gd);
        this.refreshRate.setSelection(this.config.getRefreshRate());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.dciSelector.getNodeId());
        this.config.setDciId(this.dciSelector.getDciId());
        this.config.setRefreshRate(this.refreshRate.getSelection());
        return true;
    }
}

