/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.TableColumnEnumerator;
import org.netxms.nxmc.modules.datacollection.widgets.TableConditionsEditor;
import org.netxms.nxmc.modules.events.widgets.EventSelector;
import org.xnap.commons.i18n.I18n;

public class EditTableThresholdDialog
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(EditTableThresholdDialog.class);
    private TableThreshold threshold;
    private EventSelector activationEvent;
    private EventSelector deactivationEvent;
    private LabeledSpinner sampleCount;
    private TableConditionsEditor conditionsEditor;
    private TableColumnEnumerator columnEnumerator;

    public EditTableThresholdDialog(Shell parentShell, TableThreshold threshold, TableColumnEnumerator columnEnumerator) {
        super(parentShell);
        this.threshold = threshold;
        this.columnEnumerator = columnEnumerator;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Edit Table Threshold"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.activationEvent = new EventSelector(dialogArea, 0);
        this.activationEvent.setLabel(i18n.tr("Activation event"));
        this.activationEvent.setEventCode((long)this.threshold.getActivationEvent());
        this.activationEvent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.deactivationEvent = new EventSelector(dialogArea, 0);
        this.deactivationEvent.setLabel(i18n.tr("Deactivation event"));
        this.deactivationEvent.setEventCode((long)this.threshold.getDeactivationEvent());
        this.deactivationEvent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sampleCount = new LabeledSpinner(dialogArea, 0);
        this.sampleCount.setLabel("Sample count");
        this.sampleCount.setRange(1, 100000);
        this.sampleCount.setSelection(this.threshold.getSampleCount());
        new Label(dialogArea, 0).setText(i18n.tr("Conditions"));
        this.conditionsEditor = new TableConditionsEditor(dialogArea, 2048, this.columnEnumerator);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 700;
        gd.heightHint = 400;
        this.conditionsEditor.setLayoutData((Object)gd);
        this.conditionsEditor.setConditions(this.threshold.getConditions());
        return dialogArea;
    }

    protected void okPressed() {
        this.threshold.setActivationEvent((int)this.activationEvent.getEventCode());
        this.threshold.setDeactivationEvent((int)this.deactivationEvent.getEventCode());
        this.threshold.setSampleCount(this.sampleCount.getSelection());
        this.threshold.setConditions(this.conditionsEditor.getConditions());
        super.okPressed();
    }
}

