/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.businessservice.propertypages.DCIAutoBind;
import org.netxms.nxmc.modules.businessservice.propertypages.InstanceDiscovery;
import org.netxms.nxmc.modules.businessservice.propertypages.ObjectAutoBind;
import org.netxms.nxmc.modules.objects.ObjectPropertiesManager;
import org.netxms.nxmc.modules.objects.propertypages.AccessControl;
import org.netxms.nxmc.modules.objects.propertypages.Agent;
import org.netxms.nxmc.modules.objects.propertypages.AutoApply;
import org.netxms.nxmc.modules.objects.propertypages.AutoBind;
import org.netxms.nxmc.modules.objects.propertypages.ClusterNetworks;
import org.netxms.nxmc.modules.objects.propertypages.ClusterResources;
import org.netxms.nxmc.modules.objects.propertypages.Comments;
import org.netxms.nxmc.modules.objects.propertypages.Communication;
import org.netxms.nxmc.modules.objects.propertypages.CustomAttributes;
import org.netxms.nxmc.modules.objects.propertypages.DashboardElements;
import org.netxms.nxmc.modules.objects.propertypages.DashboardObjectContext;
import org.netxms.nxmc.modules.objects.propertypages.Dashboards;
import org.netxms.nxmc.modules.objects.propertypages.EtherNetIP;
import org.netxms.nxmc.modules.objects.propertypages.ExternalResources;
import org.netxms.nxmc.modules.objects.propertypages.General;
import org.netxms.nxmc.modules.objects.propertypages.ICMP;
import org.netxms.nxmc.modules.objects.propertypages.InterfacePolling;
import org.netxms.nxmc.modules.objects.propertypages.Location;
import org.netxms.nxmc.modules.objects.propertypages.LocationControl;
import org.netxms.nxmc.modules.objects.propertypages.MQTT;
import org.netxms.nxmc.modules.objects.propertypages.MapAppearance;
import org.netxms.nxmc.modules.objects.propertypages.MapOptions;
import org.netxms.nxmc.modules.objects.propertypages.MapSeedNodes;
import org.netxms.nxmc.modules.objects.propertypages.NetworkServicePolling;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.PhysicalContainerPlacement;
import org.netxms.nxmc.modules.objects.propertypages.Polling;
import org.netxms.nxmc.modules.objects.propertypages.RackPassiveElements;
import org.netxms.nxmc.modules.objects.propertypages.RackProperties;
import org.netxms.nxmc.modules.objects.propertypages.ResponsibleUsers;
import org.netxms.nxmc.modules.objects.propertypages.SNMP;
import org.netxms.nxmc.modules.objects.propertypages.SSH;
import org.netxms.nxmc.modules.objects.propertypages.SensorProperties;
import org.netxms.nxmc.modules.objects.propertypages.StatusCalculation;
import org.netxms.nxmc.modules.objects.propertypages.Syslog;
import org.netxms.nxmc.modules.objects.propertypages.TrustedNodes;
import org.netxms.nxmc.modules.objects.propertypages.VPNSubnets;
import org.netxms.nxmc.modules.objects.propertypages.WebServices;
import org.netxms.nxmc.modules.objects.propertypages.ZoneAgentCredentials;
import org.netxms.nxmc.modules.objects.propertypages.ZoneCommunications;
import org.netxms.nxmc.modules.objects.propertypages.ZoneSNMPCredentials;
import org.netxms.nxmc.modules.objects.propertypages.ZoneSSHCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class ObjectPropertiesManager {
    private static final Logger logger = LoggerFactory.getLogger(ObjectPropertiesManager.class);
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectPropertiesManager.class);
    private static Set<Class<? extends ObjectPropertyPage>> pageClasses = new HashSet();

    public static boolean openObjectPropertiesDialog(AbstractObject object, Shell shell) {
        ArrayList<ObjectPropertyPage> pages = new ArrayList<ObjectPropertyPage>(pageClasses.size());
        for (Iterator c : pageClasses) {
            try {
                ObjectPropertyPage p = (ObjectPropertyPage)((Class)((Object)c)).getConstructor(AbstractObject.class).newInstance(object);
                if (!p.isVisible()) continue;
                pages.add(p);
            }
            catch (Exception e) {
                logger.error("Error instantiating object property page", (Throwable)e);
            }
        }
        pages.sort((Comparator<ObjectPropertyPage>)new /* Unavailable Anonymous Inner Class!! */);
        PreferenceManager pm = new PreferenceManager();
        for (ObjectPropertyPage p : pages) {
            if (p.getParentId() != null) continue;
            pm.addToRoot((IPreferenceNode)new PreferenceNode(p.getId(), (IPreferencePage)p));
        }
        for (ObjectPropertyPage p : pages) {
            String parentId = p.getParentId();
            if (parentId == null) continue;
            pm.addTo(parentId, (IPreferenceNode)new PreferenceNode(p.getId(), (IPreferencePage)p));
        }
        2 dlg = new /* Unavailable Anonymous Inner Class!! */;
        dlg.setBlockOnOpen(true);
        return dlg.open() == 0;
    }

    static {
        pageClasses.add(AccessControl.class);
        pageClasses.add(Agent.class);
        pageClasses.add(AutoApply.class);
        pageClasses.add(AutoBind.class);
        pageClasses.add(ObjectAutoBind.class);
        pageClasses.add(DCIAutoBind.class);
        pageClasses.add(ClusterNetworks.class);
        pageClasses.add(ClusterResources.class);
        pageClasses.add(Comments.class);
        pageClasses.add(Communication.class);
        pageClasses.add(CustomAttributes.class);
        pageClasses.add(Dashboards.class);
        pageClasses.add(DashboardElements.class);
        pageClasses.add(DashboardObjectContext.class);
        pageClasses.add(EtherNetIP.class);
        pageClasses.add(ExternalResources.class);
        pageClasses.add(General.class);
        pageClasses.add(ICMP.class);
        pageClasses.add(InstanceDiscovery.class);
        pageClasses.add(InterfacePolling.class);
        pageClasses.add(Location.class);
        pageClasses.add(LocationControl.class);
        pageClasses.add(MapAppearance.class);
        pageClasses.add(MapOptions.class);
        pageClasses.add(MapSeedNodes.class);
        pageClasses.add(MQTT.class);
        pageClasses.add(NetworkServicePolling.class);
        pageClasses.add(PhysicalContainerPlacement.class);
        pageClasses.add(Polling.class);
        pageClasses.add(RackPassiveElements.class);
        pageClasses.add(RackProperties.class);
        pageClasses.add(ResponsibleUsers.class);
        pageClasses.add(SensorProperties.class);
        pageClasses.add(SNMP.class);
        pageClasses.add(SSH.class);
        pageClasses.add(StatusCalculation.class);
        pageClasses.add(Syslog.class);
        pageClasses.add(TrustedNodes.class);
        pageClasses.add(VPNSubnets.class);
        pageClasses.add(WebServices.class);
        pageClasses.add(ZoneAgentCredentials.class);
        pageClasses.add(ZoneCommunications.class);
        pageClasses.add(ZoneSNMPCredentials.class);
        pageClasses.add(ZoneSSHCredentials.class);
    }
}

