/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectContextMenuManager;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectView;
import org.netxms.nxmc.modules.objects.widgets.DeviceViewWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.PortSelectionListener;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class PortView
extends NodeSubObjectView
implements ISelectionProvider {
    private static final I18n i18n = LocalizationHelper.getI18n(PortView.class);
    private NXCSession session = Registry.getSession();
    private ScrolledComposite scroller;
    private DeviceViewWidget deviceView;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet();

    public PortView() {
        super(i18n.tr("Ports"), ResourceManager.getImageDescriptor((String)"icons/object-views/ports.png"), "Ports", false);
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).isBridge();
    }

    public int getPriority() {
        return 70;
    }

    protected void onObjectChange(AbstractObject object) {
        this.deviceView.setNodeId(object != null ? object.getObjectId() : 0L);
        this.scroller.setMinSize(this.deviceView.computeSize(-1, -1));
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.scroller = new ScrolledComposite(this.mainArea, 768);
        this.deviceView = new DeviceViewWidget((Composite)this.scroller, 0);
        this.deviceView.addSelectionListener((PortSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.scroller.setBackground(this.deviceView.getBackground());
        this.scroller.setContent((Control)this.deviceView);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createContextMenu();
    }

    public void refresh() {
        this.deviceView.setNodeId(this.getObjectId());
        this.scroller.setMinSize(this.deviceView.computeSize(-1, -1));
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof Interface && object.isDirectChildOf(this.getObjectId());
    }

    private void createContextMenu() {
        ObjectContextMenuManager menuMgr = new ObjectContextMenuManager((View)this, (ISelectionProvider)this);
        this.deviceView.setMenu(menuMgr.createContextMenu((Control)this.deviceView));
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

