/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.ScheduledTask;
import org.netxms.client.SessionListener;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ScheduledTaskComparator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ScheduledTaskFilter;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ScheduledTaskLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ScheduledTasks
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(ScheduledTasks.class);
    public static final int SCHEDULE_ID = 0;
    public static final int CALLBACK_ID = 1;
    public static final int OBJECT = 2;
    public static final int PARAMETERS = 3;
    public static final int TIMER_KEY = 4;
    public static final int EXECUTION_TIME = 5;
    public static final int LAST_EXECUTION_TIME = 6;
    public static final int STATUS = 7;
    public static final int MANAGMENT_STATE = 8;
    public static final int OWNER = 9;
    public static final int COMMENTS = 10;
    private NXCSession session = Registry.getSession();
    private SessionListener listener;
    private SortableTableViewer viewer;
    private ScheduledTaskFilter filter;
    private Action actionShowCompletedTasks;
    private Action actionShowDisabledTasks;
    private Action actionShowSystemTasks;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionDisable;
    private Action actionEnable;
    private Action actionReschedule;

    public ScheduledTasks() {
        super(i18n.tr("Scheduled Tasks"), ResourceManager.getImageDescriptor((String)"icons/config-views/scheduled-tasks.png"), "ScheduledTasks", true);
    }

    public void createContent(Composite parent) {
        int[] widths = new int[]{50, 100, 200, 400, 200, 150, 150, 100, 200, 250, 200};
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Schedule Type"), i18n.tr("Object"), i18n.tr("Parameters"), i18n.tr("Timer key"), i18n.tr("Execution time"), i18n.tr("Last execution time"), i18n.tr("Execution status"), i18n.tr("Administrative status"), i18n.tr("Owner"), i18n.tr("Comments")};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScheduledTaskLabelProvider(this.viewer));
        this.viewer.setComparator((ViewerComparator)new ScheduledTaskComparator());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.filter = new ScheduledTaskFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"ScheduledTasks");
        PreferenceStore settings = PreferenceStore.getInstance();
        this.filter.setShowCompletedTasks(settings.getAsBoolean("ScheduledTasks.showCompleted", true));
        this.filter.setShowDisabledTasks(settings.getAsBoolean("ScheduledTasks.showDisabled", true));
        this.filter.setShowSystemTasks(settings.getAsBoolean("ScheduledTasks.showSystem", false));
        this.viewer.getControl().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        Display display = parent.getDisplay();
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.listener);
    }

    protected void postContentCreate() {
        this.refresh();
    }

    private void createActions() {
        this.actionShowCompletedTasks = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowCompletedTasks.setChecked(this.filter.isShowCompletedTasks());
        this.actionShowDisabledTasks = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowDisabledTasks.setChecked(this.filter.isShowDisabledTasks());
        this.actionShowSystemTasks = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowSystemTasks.setChecked(this.filter.isShowSystemTasks());
        this.actionCreate = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionCreate);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M3+ENTER", (IAction)this.actionEdit);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionDisable = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+I", (IAction)this.actionDisable);
        this.actionEnable = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+E", (IAction)this.actionEnable);
        this.actionReschedule = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+R", (IAction)this.actionReschedule);
    }

    protected void deleteTask() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete Task"), (String)(selection.size() == 1 ? i18n.tr("Selected task will be deleted. Are you sure?") : i18n.tr("Selected tasks will be deleted. Are you sure?")))) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void editTask(boolean reschedule) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ScheduledTask originalTask = (ScheduledTask)selection.getFirstElement();
        if (reschedule) {
            originalTask.setId(0L);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void setScheduledTaskEnabled(boolean enabled) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createTask() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowCompletedTasks);
        manager.add((IAction)this.actionShowDisabledTasks);
        manager.add((IAction)this.actionShowSystemTasks);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1) {
            ScheduledTask origin = (ScheduledTask)selection.toList().get(0);
            if (origin.getSchedule().isEmpty()) {
                mgr.add((IAction)this.actionReschedule);
            } else {
                mgr.add((IAction)this.actionEdit);
            }
        }
        boolean containDisabled = false;
        boolean containEnabled = false;
        for (Object o : selection.toList()) {
            if (((ScheduledTask)o).isDisabled()) {
                containDisabled = true;
            } else {
                containEnabled = true;
            }
            if (!containDisabled || !containEnabled) continue;
            break;
        }
        if (containDisabled) {
            mgr.add((IAction)this.actionEnable);
        }
        if (containEnabled) {
            mgr.add((IAction)this.actionDisable);
        }
        if (selection.size() > 0) {
            mgr.add((IAction)this.actionDelete);
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionCreate);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void dispose() {
        if (this.listener != null && this.session != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

