/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.widgets.helpers.HardwareComponentComparator;
import org.netxms.ui.eclipse.objectview.widgets.helpers.HardwareComponentLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class HardwareInventory
extends Composite {
    public static final int COLUMN_CATEGORY = 0;
    public static final int COLUMN_INDEX = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_VENDOR = 3;
    public static final int COLUMN_MODEL = 4;
    public static final int COLUMN_CAPACITY = 5;
    public static final int COLUMN_PART_NUMBER = 6;
    public static final int COLUMN_SERIAL_NUMBER = 7;
    public static final int COLUMN_LOCATION = 8;
    public static final int COLUMN_DESCRIPTION = 9;
    private static final String[] names = new String[]{"Category", "Index", "Type", "Vendor", "Model", "Capacity", "Part number", "Serial number", "Location", "Description"};
    private static final int[] widths = new int[]{100, 70, 100, 200, 200, 90, 130, 130, 200, 300};
    private IViewPart viewPart;
    private long rootObjectId;
    private ColumnViewer viewer;
    private String configPrefix;
    private MenuManager menuManager = null;

    public HardwareInventory(Composite parent, int style, IViewPart viewPart, String configPrefix) {
        super(parent, style);
        this.viewPart = viewPart;
        this.configPrefix = configPrefix;
        this.setLayout((Layout)new FillLayout());
        this.createTableViewer();
    }

    private void createTableViewer() {
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 0, 128, 65538);
        WidgetHelper.restoreColumnViewerSettings((ColumnViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)this.configPrefix);
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnViewerSettings((ColumnViewer)HardwareInventory.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)HardwareInventory.this.configPrefix);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new HardwareComponentLabelProvider());
        this.viewer.setComparator((ViewerComparator)new HardwareComponentComparator());
        if (this.menuManager != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.viewer);
        }
    }

    public void refresh() {
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Loading hardware inventory", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.objectview", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List components = session.getNodeHardwareComponents(HardwareInventory.this.rootObjectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).HardwareInventory.this.viewer.setInput((Object)components.toArray());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Unable to get node hardware inventory";
            }
        }.start();
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }

    public long getRootObjectId() {
        return this.rootObjectId;
    }

    public void setRootObjectId(long rootObjectId) {
        this.rootObjectId = rootObjectId;
    }

    public void setViewerMenu(MenuManager manager) {
        this.menuManager = manager;
        if (this.viewer != null) {
            Menu menu = this.menuManager.createContextMenu(this.viewer.getControl());
            this.viewer.getControl().setMenu(menu);
            this.viewPart.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this.viewer);
        }
    }
}

