/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.views;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCException;
import org.netxms.client.TableRow;
import org.netxms.client.events.Alarm;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.logviewer.views.LogViewer;
import org.netxms.ui.eclipse.tools.ExternalWebBrowser;

public class AlarmLogViewer
extends LogViewer {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.views.alarm_log_viewer";
    private Action actionCreateIssue;
    private Action actionShowIssue;
    private Action actionUnlinkIssue;

    protected void createActions() {
        super.createActions();
        this.actionCreateIssue = new Action("Create &ticket in helpdesk system", Activator.getImageDescriptor("icons/helpdesk_ticket.png")){

            public void run() {
                AlarmLogViewer.this.createIssue();
            }
        };
        this.actionShowIssue = new Action("Show helpdesk ticket in &web browser", SharedIcons.BROWSER){

            public void run() {
                AlarmLogViewer.this.showIssue();
            }
        };
        this.actionUnlinkIssue = new Action("Unlink from helpdesk ticket"){

            public void run() {
                AlarmLogViewer.this.unlinkIssue();
            }
        };
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0 && this.session.isHelpdeskLinkActive()) {
            try {
                Alarm alarm = this.session.getAlarm(Long.parseLong(((TableRow)selection.getFirstElement()).get(0).getValue()));
                if (alarm.getHelpdeskState() == 0) {
                    mgr.add((IAction)this.actionCreateIssue);
                } else {
                    mgr.add((IAction)this.actionShowIssue);
                    if ((this.session.getUserSystemRights() & 0x10000000L) != 0L) {
                        mgr.add((IAction)this.actionUnlinkIssue);
                    }
                }
            }
            catch (IOException | ArrayIndexOutOfBoundsException | NumberFormatException | NXCException e) {
                Activator.logError("Error finding alarm", (Exception)e);
            }
        }
    }

    private void createIssue() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = Long.parseLong(((TableRow)selection.getFirstElement()).get(0).getValue());
        new ConsoleJob("Create helpdesk ticket", (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmLogViewer.this.session.openHelpdeskIssue(id);
            }

            protected String getErrorMessage() {
                return "Cannot create helpdesk ticket from alarm";
            }
        }.start();
    }

    private void showIssue() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = Long.parseLong(((TableRow)selection.getFirstElement()).get(0).getValue());
        new ConsoleJob("Show helpdesk ticket", (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String url = AlarmLogViewer.this.session.getHelpdeskIssueUrl(id);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ExternalWebBrowser.open((String)url);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get URL for helpdesk ticket";
            }
        }.start();
    }

    private void unlinkIssue() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = Long.parseLong(((TableRow)selection.getFirstElement()).get(0).getValue());
        new ConsoleJob("Unlink alarm from helpdesk ticket", (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmLogViewer.this.session.unlinkHelpdeskIssue(id);
            }

            protected String getErrorMessage() {
                return "Cannot unlink alarm from helpdesk ticket";
            }
        }.start();
    }
}

