/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.base.InetAddressEx;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Zone;
import org.netxms.client.objects.queries.ObjectQueryResult;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectSearchResultLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private WorkbenchLabelProvider wbLabelProvider = new WorkbenchLabelProvider();
    private Table table;

    public ObjectSearchResultLabelProvider(Table table) {
        this.table = table;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        AbstractObject object = element instanceof ObjectQueryResult ? ((ObjectQueryResult)element).getObject() : (AbstractObject)element;
        return this.wbLabelProvider.getImage((Object)object);
    }

    public String getColumnText(Object element, int columnIndex) {
        String propertyName;
        AbstractObject object = element instanceof ObjectQueryResult ? ((ObjectQueryResult)element).getObject() : (AbstractObject)element;
        switch (columnIndex) {
            case 1: {
                return object.getObjectClassName();
            }
            case 0: {
                return Long.toString(object.getObjectId());
            }
            case 3: {
                if (object instanceof AbstractNode) {
                    InetAddressEx addr = ((AbstractNode)object).getPrimaryIP();
                    return addr.isValidUnicastAddress() ? addr.getHostAddress() : null;
                }
                if (object instanceof AccessPoint) {
                    InetAddressEx addr = ((AccessPoint)object).getIpAddress();
                    return addr.isValidUnicastAddress() ? addr.getHostAddress() : null;
                }
                if (object instanceof Interface) {
                    return ((Interface)object).getIpAddressListAsString();
                }
                return null;
            }
            case 2: {
                return this.wbLabelProvider.getText((Object)object);
            }
            case 4: {
                return ObjectSearchResultLabelProvider.getParentNames(object);
            }
            case 5: {
                if (!ConsoleSharedData.getSession().isZoningEnabled()) break;
                if (object instanceof AbstractNode) {
                    int zoneId = ((AbstractNode)object).getZoneId();
                    Zone zone = ConsoleSharedData.getSession().findZone(zoneId);
                    return zone != null ? String.valueOf(zone.getObjectName()) + " (" + Integer.toString(zoneId) + ")" : Integer.toString(zoneId);
                }
                if (!(object instanceof Interface)) break;
                int zoneId = ((Interface)object).getZoneId();
                Zone zone = ConsoleSharedData.getSession().findZone(zoneId);
                return zone != null ? String.valueOf(zone.getObjectName()) + " (" + Integer.toString(zoneId) + ")" : Integer.toString(zoneId);
            }
        }
        if (element instanceof ObjectQueryResult && (propertyName = this.getPropertyName(columnIndex)) != null) {
            return ((ObjectQueryResult)element).getPropertyValue(propertyName);
        }
        return null;
    }

    private String getPropertyName(int columnIndex) {
        TableColumn c = this.table.getColumn(columnIndex);
        return c != null ? (String)c.getData("propertyName") : null;
    }

    private static String getParentNames(AbstractObject object) {
        StringBuilder sb = new StringBuilder();
        AbstractObject[] abstractObjectArray = object.getParentsAsArray();
        int n = abstractObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractObject o = abstractObjectArray[n2];
            if (o instanceof AbstractNode || o instanceof Container || o instanceof Rack || o instanceof Cluster) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(o.getObjectName());
            }
            ++n2;
        }
        return sb.toString();
    }

    public void dispose() {
        this.wbLabelProvider.dispose();
        super.dispose();
    }
}

