/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.widgets.helpers;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ConnectionPointType;
import org.netxms.client.objects.Interface;
import org.netxms.client.topology.ConnectionPoint;
import org.netxms.ui.eclipse.console.ViewerElementUpdater;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.topology.Messages;

public class ConnectionPointLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color COLOR_FOUND_OBJECT_DIRECT = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"DarkGreen"));
    private static final Color COLOR_FOUND_OBJECT_INDIRECT = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"SeaGreen"));
    private static final Color COLOR_FOUND_OBJECT_WIRELESS = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"Teal"));
    private static final Color COLOR_FOUND_OBJECT_UNKNOWN = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"Peru"));
    private static final Color COLOR_FOUND_MAC_DIRECT = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"DarkBlue"));
    private static final Color COLOR_FOUND_MAC_INDIRECT = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"DarkSlateBlue"));
    private static final Color COLOR_FOUND_MAC_WIRELESS = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"SteelBlue"));
    private static final Color COLOR_NOT_FOUND = new Color((Device)Display.getDefault(), ColorConverter.parseColorDefinition((String)"DarkRed"));
    private Map<Long, String> cachedObjectNames = new HashMap<Long, String>();
    private NXCSession session = ConsoleSharedData.getSession();
    private TableViewer viewer;

    public ConnectionPointLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    private String getObjectName(long id) {
        if (id == 0L) {
            return "";
        }
        String name = this.cachedObjectNames.get(id);
        if (name == null) {
            name = this.session.getObjectName(id);
            this.cachedObjectNames.put(id, name);
        }
        return name;
    }

    public String getColumnText(Object element, int columnIndex) {
        ConnectionPoint cp = (ConnectionPoint)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString((Integer)cp.getData() + 1);
            }
            case 1: {
                return this.getObjectName(cp.getLocalNodeId());
            }
            case 2: {
                return this.getObjectName(cp.getLocalInterfaceId());
            }
            case 3: {
                if (cp.getLocalMacAddress() == null) {
                    return "n/a";
                }
                String vendor = this.session.getVendorByMac(cp.getLocalMacAddress(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return vendor != null && !vendor.isEmpty() ? String.format("%s (%s)", cp.getLocalMacAddress().toString(), vendor) : cp.getLocalMacAddress().toString();
            }
            case 4: {
                InetAddress addr = cp.getLocalIpAddress();
                if (addr != null) {
                    return addr.getHostAddress();
                }
                Interface iface = (Interface)this.session.findObjectById(cp.getLocalInterfaceId(), Interface.class);
                if (iface == null) {
                    return "";
                }
                InetAddress a = iface.getFirstUnicastAddress();
                return a != null ? a.getHostAddress() : "";
            }
            case 5: {
                if (cp.getNodeId() == 0L) {
                    return "n/a";
                }
                return this.getObjectName(cp.getNodeId());
            }
            case 6: {
                if (cp.getInterfaceId() == 0L) {
                    return "n/a";
                }
                return this.getObjectName(cp.getInterfaceId());
            }
            case 7: {
                if (cp.getType() == null) {
                    return "n/a";
                }
                switch (cp.getType()) {
                    case DIRECT: {
                        Messages.get();
                        return Messages.ConnectionPointLabelProvider_Direct;
                    }
                    case INDIRECT: {
                        Messages.get();
                        return Messages.ConnectionPointLabelProvider_Indirect;
                    }
                    case WIRELESS: {
                        Messages.get();
                        return Messages.ConnectionPointLabelProvider_Wireless;
                    }
                }
                Messages.get();
                return Messages.ConnectionPointLabelProvider_Unknown;
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        ConnectionPoint cp = (ConnectionPoint)element;
        if (!cp.hasConnection()) {
            return COLOR_NOT_FOUND;
        }
        if (cp.getLocalNodeId() == 0L) {
            return cp.getType() == ConnectionPointType.DIRECT ? COLOR_FOUND_MAC_DIRECT : (cp.getType() == ConnectionPointType.WIRELESS ? COLOR_FOUND_MAC_WIRELESS : COLOR_FOUND_MAC_INDIRECT);
        }
        switch (cp.getType()) {
            case DIRECT: {
                return COLOR_FOUND_OBJECT_DIRECT;
            }
            case INDIRECT: {
                return COLOR_FOUND_OBJECT_INDIRECT;
            }
            case WIRELESS: {
                return COLOR_FOUND_OBJECT_WIRELESS;
            }
            case UNKNOWN: {
                return COLOR_FOUND_OBJECT_UNKNOWN;
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

