/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.actions;

import java.io.FileInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.dialogs.ConfigurationImportDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ImportConfiguration
implements IWorkbenchWindowActionDelegate {
    private Shell shell;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.shell = window.getShell();
    }

    public void run(IAction action) {
        final ConfigurationImportDialog dlg = new ConfigurationImportDialog(this.shell);
        if (dlg.open() == 0) {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            ConsoleJob job = new ConsoleJob(Messages.ImportConfiguration_JobName, null, "org.netxms.ui.eclipse.serverconfig", null){

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ImportConfiguration_JobError;
                }

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    FileInputStream file = new FileInputStream(dlg.getFileName());
                    byte[] data = new byte[(int)file.getChannel().size()];
                    file.read(data);
                    file.close();
                    String content = new String(data, "UTF-8");
                    session.importConfiguration(content, dlg.getFlags());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = (this).ImportConfiguration.this.shell;
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openInformation((Shell)shell, (String)Messages.ImportConfiguration_Information, (String)String.format(Messages.ImportConfiguration_SuccessMessage, dlg.getFileName()));
                        }
                    });
                }
            };
            job.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

