/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.views;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.InputField;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.queries.ObjectQuery;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.InputFieldEntryDialog;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectQueryEditDialog;
import org.netxms.ui.eclipse.objectbrowser.views.ObjectQueryResultView;
import org.netxms.ui.eclipse.objectbrowser.views.helpers.ObjectQueryComparator;
import org.netxms.ui.eclipse.objectbrowser.views.helpers.ObjectQueryLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.RefreshTimer;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ObjectQueryManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objectbrowser.views.ObjectQueryManager";
    public static final int COL_ID = 0;
    public static final int COL_NAME = 1;
    public static final int COL_DESCRIPTION = 2;
    public static final int COL_IS_VALID = 3;
    private NXCSession session = ConsoleSharedData.getSession();
    private SessionListener sessionListener;
    private SortableTableViewer viewer;
    private RefreshTimer refreshTimer;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionExecute;
    private Action actionRefresh;

    public void createPartControl(Composite parent) {
        String[] names = new String[]{"ID", "Name", "Description", "Valid"};
        int[] widths = new int[]{120, 300, 600, 60};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectQueryLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectQueryComparator());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectQueryManager.this.editQuery();
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createContextMenu();
        this.refresh();
        this.refreshTimer = new RefreshTimer(500, this.viewer.getControl(), new Runnable(){

            @Override
            public void run() {
                ObjectQueryManager.this.refresh();
            }
        });
        this.sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 1054 || n.getCode() == 1055) {
                    ObjectQueryManager.this.refreshTimer.execute();
                }
            }
        };
        this.session.addListener(this.sessionListener);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                ObjectQueryManager.this.refresh();
            }
        };
        this.actionCreate = new Action("&New...", SharedIcons.ADD_OBJECT){

            public void run() {
                ObjectQueryManager.this.createQuery();
            }
        };
        this.actionEdit = new Action("&Edit...", SharedIcons.EDIT){

            public void run() {
                ObjectQueryManager.this.editQuery();
            }
        };
        this.actionDelete = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                ObjectQueryManager.this.deleteQueries();
            }
        };
        this.actionExecute = new Action("E&xecute", SharedIcons.EXECUTE){

            public void run() {
                ObjectQueryManager.this.executeQuery();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createContextMenu() {
        final MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                IStructuredSelection selection = ObjectQueryManager.this.viewer.getStructuredSelection();
                manager.add((IAction)ObjectQueryManager.this.actionCreate);
                if (selection.size() == 1) {
                    manager.add((IAction)ObjectQueryManager.this.actionEdit);
                }
                if (!selection.isEmpty()) {
                    manager.add((IAction)ObjectQueryManager.this.actionDelete);
                }
                if (selection.size() == 1) {
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)ObjectQueryManager.this.actionExecute);
                }
            }
        });
        Menu menu = manager.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    private void refresh() {
        new ConsoleJob("Loading predefined object queries", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List queries = ObjectQueryManager.this.session.getObjectQueries();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        IStructuredSelection selection = (this).ObjectQueryManager.this.viewer.getStructuredSelection();
                        (this).ObjectQueryManager.this.viewer.setInput((Object)queries);
                        if (!selection.isEmpty()) {
                            ArrayList<ObjectQuery> newSelection = new ArrayList<ObjectQuery>();
                            block0: for (Object q : selection.toList()) {
                                int id = ((ObjectQuery)q).getId();
                                for (ObjectQuery nq : queries) {
                                    if (nq.getId() != id) continue;
                                    newSelection.add(nq);
                                    continue block0;
                                }
                            }
                            if (!newSelection.isEmpty()) {
                                (this).ObjectQueryManager.this.viewer.setSelection((ISelection)new StructuredSelection(newSelection));
                            }
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot load predefined object queries";
            }
        }.start();
    }

    private void createQuery() {
        ObjectQueryEditDialog dlg = new ObjectQueryEditDialog(this.getSite().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        final ObjectQuery query = dlg.getQuery();
        new ConsoleJob("Creating object query", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ObjectQueryManager.this.session.modifyObjectQuery(query);
            }

            protected String getErrorMessage() {
                return "Cannot create object query";
            }
        }.start();
    }

    private void editQuery() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final ObjectQuery query = (ObjectQuery)selection.getFirstElement();
        ObjectQueryEditDialog dlg = new ObjectQueryEditDialog(this.getSite().getShell(), query);
        if (dlg.open() != 0) {
            return;
        }
        new ConsoleJob("Updating object query", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ObjectQueryManager.this.session.modifyObjectQuery(query);
            }

            protected String getErrorMessage() {
                return "Cannot update object query";
            }
        }.start();
    }

    private void deleteQueries() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete", (String)"Selected object queries will be permanently deleted. Are you sure?")) {
            return;
        }
        final ArrayList<Integer> idList = new ArrayList<Integer>(selection.size());
        for (Object o : selection.toList()) {
            idList.add(((ObjectQuery)o).getId());
        }
        new ConsoleJob("Deleting object queries", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Integer id : idList) {
                    ObjectQueryManager.this.session.deleteObjectQuery(id.intValue());
                }
            }

            protected String getErrorMessage() {
                return "Cannot delete object query";
            }
        }.start();
    }

    private void executeQuery() {
        Map<Object, Object> inputValues;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final ObjectQuery query = (ObjectQuery)selection.getFirstElement();
        List fields = query.getInputFields();
        if (!fields.isEmpty()) {
            fields.sort(new Comparator<InputField>(){

                @Override
                public int compare(InputField f1, InputField f2) {
                    return f1.getSequence() - f2.getSequence();
                }
            });
            inputValues = InputFieldEntryDialog.readInputFields(query.getName(), fields.toArray(new InputField[fields.size()]));
            if (inputValues == null) {
                return;
            }
        } else {
            inputValues = new HashMap(0);
        }
        new ConsoleJob("Executing object query", (IWorkbenchPart)this, "org.netxms.ui.eclipse.objectbrowser"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List resultSet = ObjectQueryManager.this.session.queryObjectDetails(query.getSource(), null, null, inputValues, true, 0);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ObjectQueryResultView view = (ObjectQueryResultView)ObjectQueryManager.this.getSite().getPage().showView("org.netxms.ui.eclipse.objectbrowser.views.ObjectQueryResultView", UUID.randomUUID().toString(), 1);
                            view.setContent(resultSet, query.getName());
                        }
                        catch (PartInitException e) {
                            MessageDialogHelper.openError((Shell)ObjectQueryManager.this.getSite().getShell(), (String)"Error", (String)String.format("Cannot open result view (%s)", e.getLocalizedMessage()));
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot execute object query";
            }
        }.start();
    }
}

