/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.GaugeConfig;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class GaugeElement
extends ComparisonChartElement {
    private GaugeConfig elementConfig;
    private Font heightCalculationFont = null;

    public GaugeElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.elementConfig = GaugeConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.elementConfig = new GaugeConfig();
        }
        this.processCommonSettings(this.elementConfig);
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLabelsVisible(this.elementConfig.isShowLegend());
        chartConfig.setLabelsInside(this.elementConfig.isLegendInside());
        chartConfig.setTransposed(this.elementConfig.isVertical());
        chartConfig.setElementBordersVisible(this.elementConfig.isElementBordersVisible());
        chartConfig.setMinYScaleValue(this.elementConfig.getMinValue());
        chartConfig.setMaxYScaleValue(this.elementConfig.getMaxValue());
        chartConfig.setLeftYellowZone(this.elementConfig.getLeftYellowZone());
        chartConfig.setLeftRedZone(this.elementConfig.getLeftRedZone());
        chartConfig.setRightYellowZone(this.elementConfig.getRightYellowZone());
        chartConfig.setRightRedZone(this.elementConfig.getRightRedZone());
        chartConfig.setFontName(this.elementConfig.getFontName());
        chartConfig.setFontSize(this.elementConfig.getFontSize());
        chartConfig.setGaugeColorMode(this.elementConfig.getColorMode());
        switch (this.elementConfig.getGaugeType()) {
            case 1: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.GAUGE, chartConfig);
                this.updateThresholds = true;
                break;
            }
            case 2: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.TEXT, chartConfig);
                this.updateThresholds = true;
                break;
            }
            default: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.DIAL, chartConfig);
            }
        }
        this.chart.setDrillDownObjectId(this.elementConfig.getDrillDownObjectId());
        this.chart.setPaletteEntry(0, new ChartColor(this.elementConfig.getCustomColor()));
        this.configureMetrics();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GaugeElement.this.heightCalculationFont != null) {
                    GaugeElement.this.heightCalculationFont.dispose();
                }
            }
        });
    }

    @Override
    protected ChartDciConfig[] getDciList() {
        return this.elementConfig.getDciList();
    }

    @Override
    protected int adjustContentHeight(Composite content, Point computedSize) {
        if (this.elementConfig.getGaugeType() == 1) {
            return this.elementConfig.isVertical() ? 40 * this.elementConfig.getDciList().length : 40;
        }
        if (this.elementConfig.getGaugeType() == 2) {
            if (this.heightCalculationFont == null) {
                int fontSize = this.elementConfig.getFontSize();
                if (fontSize == 0) {
                    fontSize = 24;
                }
                this.heightCalculationFont = new Font((Device)this.getDisplay(), this.elementConfig.getFontName(), fontSize, 1);
            }
            int h = WidgetHelper.getTextExtent((Control)this, (Font)this.heightCalculationFont, (String)"X").y + 10;
            return this.elementConfig.isVertical() ? h * this.elementConfig.getDciList().length : h;
        }
        return super.adjustContentHeight(content, computedSize);
    }
}

