/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.ViewRefreshController;

public abstract class ScriptedComparisonChartElement
extends ElementWidget {
    protected Chart chart;
    protected NXCSession session = ConsoleSharedData.getSession();
    protected String script = null;
    protected long objectId = 0L;
    protected int refreshInterval = 30;
    protected boolean updateThresholds = false;
    private ViewRefreshController refreshController;
    private boolean updateInProgress = false;

    public ScriptedComparisonChartElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ScriptedComparisonChartElement.this.refreshController != null) {
                    ScriptedComparisonChartElement.this.refreshController.dispose();
                }
            }
        });
    }

    protected void startRefreshTimer() {
        this.refreshController = new ViewRefreshController(this.viewPart, this.refreshInterval, new Runnable(){

            @Override
            public void run() {
                if (ScriptedComparisonChartElement.this.isDisposed()) {
                    return;
                }
                ScriptedComparisonChartElement.this.refreshData();
            }
        });
        this.refreshData();
    }

    protected void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ComparisonChartElement_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map values = ScriptedComparisonChartElement.this.session.queryScript(ScriptedComparisonChartElement.this.objectId != 0L ? ScriptedComparisonChartElement.this.objectId : ScriptedComparisonChartElement.this.getDashboardObjectId(), ScriptedComparisonChartElement.this.script, null, null);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ScriptedComparisonChartElement.this.chart.isDisposed()) {
                            return;
                        }
                        (this).ScriptedComparisonChartElement.this.chart.removeAllParameters();
                        for (Map.Entry e : values.entrySet()) {
                            double value;
                            GraphItem item;
                            if (((String)e.getValue()).startsWith("{")) {
                                GraphElement ge = (GraphElement)new Gson().fromJson((String)e.getValue(), GraphElement.class);
                                String name = ge.name != null && !ge.name.isBlank() ? ge.name : (String)e.getKey();
                                item = new GraphItem(name, name, null);
                                if (ge.color != null && !ge.color.isBlank()) {
                                    item.setColor(ColorConverter.rgbToInt((RGB)ColorConverter.parseColorDefinition((String)ge.color)));
                                }
                                value = ge.value;
                            } else {
                                item = new GraphItem((String)e.getKey(), (String)e.getKey(), null);
                                value = ScriptedComparisonChartElement.safeParseDouble((String)e.getValue());
                            }
                            int index = (this).ScriptedComparisonChartElement.this.chart.addParameter(item);
                            (this).ScriptedComparisonChartElement.this.chart.updateParameter(index, value, false);
                        }
                        (this).ScriptedComparisonChartElement.this.chart.rebuild();
                        (this).ScriptedComparisonChartElement.this.chart.clearErrors();
                        (this).ScriptedComparisonChartElement.this.updateInProgress = false;
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ComparisonChartElement_JobError;
            }

            protected void jobFailureHandler() {
                ScriptedComparisonChartElement.this.updateInProgress = false;
                super.jobFailureHandler();
            }

            protected IStatus createFailureStatus(final Exception e) {
                Activator.logError("Cannot read data for scripted chart", e);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ScriptedComparisonChartElement.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    private static double safeParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 250) {
            size.y = 250;
        }
        return size;
    }

    private static class GraphElement {
        String name = null;
        String color = null;
        double value = 0.0;

        private GraphElement() {
        }
    }
}

