/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;

public class NetworkMapPage {
    private String id;
    private long nextElementId;
    private long nextLinkId;
    private Map<Long, NetworkMapElement> elements = new HashMap<Long, NetworkMapElement>(0);
    private Map<Long, NetworkMapLink> links = new HashMap<Long, NetworkMapLink>(0);

    public NetworkMapPage(String id) {
        this.id = id;
        this.nextElementId = 1L;
        this.nextLinkId = 1L;
    }

    public void addElement(NetworkMapElement element) {
        this.elements.put(element.getId(), element);
        if (element.getId() >= this.nextElementId) {
            this.nextElementId = element.getId() + 1L;
        }
    }

    public void addAllElements(Collection<NetworkMapElement> set) {
        for (NetworkMapElement e : set) {
            this.addElement(e);
        }
    }

    public void addLink(NetworkMapLink link) {
        link.resetPosition();
        for (NetworkMapLink l : this.links.values()) {
            if ((l.getElement1() != link.getElement1() || l.getElement2() != link.getElement2()) && (l.getElement1() != link.getElement2() || l.getElement2() != link.getElement1()) || l.getId() == link.getId()) continue;
            l.updatePosition();
            link.setDuplicateCount(l.getDuplicateCount());
        }
        this.links.put(link.getId(), link);
        if (link.getId() >= this.nextLinkId) {
            this.nextLinkId = link.getId() + 1L;
        }
    }

    public void addAllLinks(Collection<NetworkMapLink> set) {
        for (NetworkMapLink l : set) {
            this.addLink(l);
        }
    }

    public NetworkMapElement getElement(long elementId, Class<? extends NetworkMapElement> requiredClass) {
        NetworkMapElement e = this.elements.get(elementId);
        if (e == null || requiredClass == null) {
            return e;
        }
        return requiredClass.isInstance(e) ? e : null;
    }

    public void removeElement(long elementId) {
        this.elements.remove(elementId);
        Iterator<Map.Entry<Long, NetworkMapLink>> it = this.links.entrySet().iterator();
        while (it.hasNext()) {
            NetworkMapLink l = it.next().getValue();
            if (l.getElement1() != elementId && l.getElement2() != elementId) continue;
            it.remove();
        }
    }

    public void removeObjectElement(long objectId) {
        long elementId = -1L;
        for (NetworkMapElement element : this.elements.values()) {
            if (!(element instanceof NetworkMapObject) || ((NetworkMapObject)element).getObjectId() != objectId) continue;
            elementId = element.getId();
            break;
        }
        if (elementId != -1L) {
            this.removeElement(elementId);
        }
    }

    public void removeLink(NetworkMapLink link) {
        this.links.remove(link.getId());
    }

    public void removeLink(long id) {
        this.links.remove(id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<NetworkMapElement> getElements() {
        return this.elements.values();
    }

    public Collection<NetworkMapLink> getLinks() {
        return this.links.values();
    }

    public List<Long> getObjectIds() {
        ArrayList<Long> objects = new ArrayList<Long>();
        for (NetworkMapElement e : this.elements.values()) {
            if (e.getType() != 1) continue;
            objects.add(((NetworkMapObject)e).getObjectId());
        }
        return objects;
    }

    public List<NetworkMapElement> getObjectElements() {
        ArrayList<NetworkMapElement> objects = new ArrayList<NetworkMapElement>();
        for (NetworkMapElement e : this.elements.values()) {
            if (e.getType() != 1) continue;
            objects.add(e);
        }
        return objects;
    }

    public long createElementId() {
        return this.nextElementId++;
    }

    public long createLinkId() {
        return this.nextLinkId++;
    }

    public NetworkMapObject findObjectElement(long objectId) {
        for (NetworkMapElement e : this.elements.values()) {
            if (!(e instanceof NetworkMapObject) || ((NetworkMapObject)e).getObjectId() != objectId) continue;
            return (NetworkMapObject)e;
        }
        return null;
    }

    public List<NetworkMapLink> findLinks(NetworkMapElement source, NetworkMapElement destination) {
        ArrayList<NetworkMapLink> result = new ArrayList<NetworkMapLink>();
        for (NetworkMapLink l : this.links.values()) {
            if (l.getElement1() != source.getId() || l.getElement2() != destination.getId()) continue;
            result.add(l);
        }
        return result;
    }

    public List<NetworkMapLink> findLinksWithStatusObject(long objectId) {
        ArrayList<NetworkMapLink> list = null;
        for (NetworkMapLink l : this.links.values()) {
            for (Long obj : l.getStatusObjects()) {
                if (obj != objectId) continue;
                if (list == null) {
                    list = new ArrayList<NetworkMapLink>();
                }
                list.add(l);
            }
        }
        return list;
    }

    public List<Long> getAllLinkStatusObjects() {
        ArrayList<Long> list = new ArrayList<Long>();
        for (NetworkMapLink l : this.links.values()) {
            for (Long obj : l.getStatusObjects()) {
                list.add(obj);
            }
        }
        return list;
    }

    public boolean areObjectsConnected(long elementId1, long elementId2) {
        for (NetworkMapLink l : this.links.values()) {
            if ((l.getElement1() != elementId1 || l.getElement2() != elementId2) && (l.getElement1() != elementId2 || l.getElement2() != elementId1)) continue;
            return true;
        }
        return false;
    }

    public Object[] getElementsAndLinks() {
        Object[] list = new Object[this.elements.size() + this.links.size()];
        int i = 0;
        for (NetworkMapElement e : this.elements.values()) {
            list[i++] = e;
        }
        for (NetworkMapLink l : this.links.values()) {
            list[i++] = l;
        }
        return list;
    }

    public NetworkMapElement[] getConnectedElements(long root) {
        HashSet<NetworkMapElement> result = new HashSet<NetworkMapElement>(0);
        for (NetworkMapLink link : this.links.values()) {
            long id;
            NetworkMapElement e;
            if (link.getElement1() != root || (e = this.elements.get(id = link.getElement2())) == null) continue;
            result.add(e);
        }
        return result.toArray(new NetworkMapElement[result.size()]);
    }
}

