/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.GeoLocationControlMode;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.GenericObject;

public class DataCollectionTarget
extends GenericObject {
    public static final int DCF_DISABLE_STATUS_POLL = 1;
    public static final int DCF_DISABLE_CONF_POLL = 2;
    public static final int DCF_DISABLE_DATA_COLLECT = 4;
    public static final int DCF_LOCATION_CHANGE_EVENT = 8;
    public static final int DCSF_UNREACHABLE = 1;
    public static final int DCSF_NETWORK_PATH_PROBLEM = 2;
    protected List<DciValue> overviewDciData;
    protected List<DciValue> tooltipDciData;
    protected GeoLocationControlMode geoLocationControlMode;
    protected long[] geoAreas;
    protected long webServiceProxyId;

    public DataCollectionTarget(long id, NXCSession session) {
        super(id, session);
        this.overviewDciData = new ArrayList<DciValue>(0);
        this.tooltipDciData = new ArrayList<DciValue>(0);
        this.geoLocationControlMode = GeoLocationControlMode.NO_CONTROL;
        this.geoAreas = new long[0];
        this.webServiceProxyId = 0L;
    }

    public DataCollectionTarget(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        int count = msg.getFieldAsInt32(501L);
        this.overviewDciData = new ArrayList<DciValue>(count);
        long fieldId = 0x72000000L;
        int i = 0;
        while (i < count) {
            this.overviewDciData.add(DciValue.createFromMessage(msg, fieldId));
            fieldId += 50L;
            ++i;
        }
        count = msg.getFieldAsInt32(542L);
        this.tooltipDciData = new ArrayList<DciValue>(count);
        fieldId = 0x73000000L;
        i = 0;
        while (i < count) {
            this.tooltipDciData.add(DciValue.createFromMessage(msg, fieldId));
            fieldId += 50L;
            ++i;
        }
        this.geoLocationControlMode = GeoLocationControlMode.getByValue(msg.getFieldAsInt32(724L));
        this.geoAreas = msg.getFieldAsUInt32Array(725L);
        this.webServiceProxyId = msg.getFieldAsInt64(778L);
    }

    public List<DciValue> getOverviewDciData() {
        return this.overviewDciData;
    }

    public List<DciValue> getTooltipDciData() {
        return this.tooltipDciData;
    }

    public GeoLocationControlMode getGeoLocationControlMode() {
        return this.geoLocationControlMode;
    }

    public long[] getGeoAreas() {
        return this.geoAreas;
    }

    public boolean isLocationChageEventGenerated() {
        return (this.flags & 8) != 0;
    }

    public long getWebServiceProxyId() {
        return this.webServiceProxyId;
    }
}

