/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.GeoLocation;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.objects.GenericObject;

public class NetworkMap
extends GenericObject {
    public static final UUID GEOMAP_BACKGROUND = UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff");
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_LAYER2_TOPOLOGY = 1;
    public static final int TYPE_IP_TOPOLOGY = 2;
    public static final int TYPE_INTERNAL_TOPOLOGY = 3;
    public static final int TYPE_OSPF_TOPOLOGY = 4;
    public static final int MF_SHOW_STATUS_ICON = 1;
    public static final int MF_SHOW_STATUS_FRAME = 2;
    public static final int MF_SHOW_STATUS_BKGND = 4;
    public static final int MF_SHOW_END_NODES = 8;
    public static final int MF_CALCULATE_STATUS = 16;
    public static final int MF_FILTER_OBJECTS = 32;
    public static final int MF_SHOW_LINK_DIRECTION = 64;
    public static final int MF_USE_L1_TOPOLOGY = 128;
    public static final int MF_CENTER_BKGND_IMAGE = 256;
    public static final int MF_TRANSLUCENT_LABEL_BKGND = 512;
    private int mapType;
    private MapLayoutAlgorithm layout;
    private UUID background;
    private GeoLocation backgroundLocation;
    private int backgroundZoom;
    private List<Long> seedObjects;
    private int defaultLinkColor;
    private int defaultLinkRouting;
    private MapObjectDisplayMode objectDisplayMode;
    private int backgroundColor;
    private int discoveryRadius;
    private String filter;
    private List<NetworkMapElement> elements;
    private List<NetworkMapLink> links;

    public NetworkMap(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        this.mapType = msg.getFieldAsInt32(357L);
        this.layout = MapLayoutAlgorithm.getByValue(msg.getFieldAsInt32(358L));
        this.background = msg.getFieldAsUUID(360L);
        this.backgroundLocation = new GeoLocation(msg.getFieldAsDouble(385L).doubleValue(), msg.getFieldAsDouble(386L).doubleValue());
        this.backgroundZoom = msg.getFieldAsInt32(387L);
        this.seedObjects = Arrays.asList(msg.getFieldAsUInt32ArrayEx(359L));
        this.defaultLinkColor = msg.getFieldAsInt32(417L);
        this.defaultLinkRouting = msg.getFieldAsInt32(423L);
        this.objectDisplayMode = MapObjectDisplayMode.getByValue(msg.getFieldAsInt32(506L));
        this.backgroundColor = msg.getFieldAsInt32(424L);
        this.discoveryRadius = msg.getFieldAsInt32(426L);
        this.filter = msg.getFieldAsString(232L);
        int count = msg.getFieldAsInt32(361L);
        this.elements = new ArrayList<NetworkMapElement>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            this.elements.add(NetworkMapElement.createMapElement(msg, varId));
            varId += 100L;
            ++i;
        }
        count = msg.getFieldAsInt32(214L);
        this.links = new ArrayList<NetworkMapLink>(count);
        varId = 0x40000000L;
        i = 0;
        while (i < count) {
            this.links.add(new NetworkMapLink(msg, varId));
            varId += 20L;
            ++i;
        }
    }

    public void prepareCopy(NXCObjectCreationData cd, NXCObjectModificationData md) {
        cd.setMapType(this.mapType);
        cd.setSeedObjectIds(this.seedObjects);
        md.setMapLayout(this.layout);
        md.setMapBackground(this.background, this.backgroundLocation, this.backgroundZoom, this.backgroundColor);
        md.setDiscoveryRadius(this.discoveryRadius);
        md.setFilter(this.filter);
        md.setMapContent(this.elements, this.links);
    }

    @Override
    public String getObjectClassName() {
        return "NetworkMap";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public int getMapType() {
        return this.mapType;
    }

    public MapLayoutAlgorithm getLayout() {
        return this.layout;
    }

    public UUID getBackground() {
        return this.background;
    }

    public List<Long> getSeedObjects() {
        return this.seedObjects;
    }

    public NetworkMapPage createMapPage() {
        NetworkMapPage page = new NetworkMapPage(this.getObjectName());
        page.addAllElements(this.elements);
        page.addAllLinks(this.links);
        return page;
    }

    public GeoLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    public int getBackgroundZoom() {
        return this.backgroundZoom;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getDefaultLinkColor() {
        return this.defaultLinkColor;
    }

    public int getDefaultLinkRouting() {
        return this.defaultLinkRouting;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final int getDiscoveryRadius() {
        return this.discoveryRadius;
    }

    public String getFilter() {
        return this.filter;
    }

    public MapObjectDisplayMode getObjectDisplayMode() {
        return this.objectDisplayMode;
    }

    @Override
    public Set<String> getStrings() {
        Set<String> strings = super.getStrings();
        NetworkMap.addString(strings, this.filter);
        return strings;
    }

    public boolean isShowStatusIcon() {
        return (this.flags & 1) != 0;
    }

    public boolean isShowStatusFrame() {
        return (this.flags & 2) != 0;
    }

    public boolean isShowStatusBackground() {
        return (this.flags & 4) != 0;
    }

    public boolean isShowEndNodes() {
        return (this.flags & 8) != 0;
    }

    public boolean isShowLinkDirection() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isCalculateStatus() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isCenterBackgroundImage() {
        return (this.flags & 0x100) != 0;
    }

    public boolean isTranslucentLabelBackground() {
        return (this.flags & 0x200) != 0;
    }
}

