/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.widgets;

import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.gef4.zest.layouts.LayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutAlgorithm;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Activator;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.algorithms.ManualLayout;
import org.netxms.ui.eclipse.networkmaps.algorithms.SparseTree;
import org.netxms.ui.eclipse.networkmaps.api.ObjectDoubleClickHandlerRegistry;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkDciValueProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapContentProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class NetworkMapWidget
extends Composite {
    protected ExtendedGraphViewer viewer;
    protected MapLabelProvider labelProvider;
    private Color defaultLinkColor = null;
    private boolean disableGeolocationBackground = false;
    private NXCSession session = ConsoleSharedData.getSession();
    private SessionListener sessionListener;
    private NetworkMapPage mapPage = null;
    private ObjectDoubleClickHandlerRegistry doubleClickHandlers;
    private Stack<Long> history = new Stack();
    private long currentMapId = 0L;
    private LinkDciValueProvider dciValueProvider = LinkDciValueProvider.getInstance();
    private IViewPart viewPart;

    public NetworkMapWidget(Composite parent, IViewPart viewPart, int style) {
        super(parent, style);
        this.viewPart = viewPart;
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        this.disableGeolocationBackground = ps.getBoolean("DISABLE_GEOLOCATION_BACKGROUND");
        this.setLayout((Layout)new FillLayout());
        this.viewer = new ExtendedGraphViewer(this, 0);
        this.labelProvider = new MapLabelProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new MapContentProvider(this.viewer, this.labelProvider));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NetworkMapWidget.this.defaultLinkColor != null) {
                    NetworkMapWidget.this.defaultLinkColor.dispose();
                }
                if (NetworkMapWidget.this.sessionListener != null) {
                    NetworkMapWidget.this.session.removeListener(NetworkMapWidget.this.sessionListener);
                }
            }
        });
        this.sessionListener = new SessionListener(){

            public void notificationHandler(final SessionNotification n) {
                if (n.getCode() == 4) {
                    NetworkMapWidget.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NetworkMapWidget.this.onObjectChange((AbstractObject)n.getObject());
                        }
                    });
                }
            }
        };
        this.session.addListener(this.sessionListener);
    }

    public void enableObjectDoubleClick() {
        this.doubleClickHandlers = new ObjectDoubleClickHandlerRegistry(this.viewPart);
        this.doubleClickHandlers.setDefaultHandlerEnabled(false);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)NetworkMapWidget.this.viewer.getSelection();
                if (selection.isEmpty() || !(selection.getFirstElement() instanceof NetworkMapObject)) {
                    return;
                }
                AbstractObject object = ConsoleSharedData.getSession().findObjectById(((NetworkMapObject)selection.getFirstElement()).getObjectId());
                if (object == null) {
                    return;
                }
                if (NetworkMapWidget.this.doubleClickHandlers.handleDoubleClick(object)) {
                    return;
                }
                NetworkMapWidget.this.openDrillDownObject(object);
            }
        });
    }

    private void openDrillDownObject(AbstractObject object) {
        long objectId;
        long l = objectId = object instanceof NetworkMap ? object.getObjectId() : object.getDrillDownObjectId();
        if (objectId == 0L) {
            return;
        }
        AbstractObject test = ConsoleSharedData.getSession().findObjectById(objectId);
        if (test instanceof NetworkMap && test != null) {
            this.history.push(this.currentMapId);
            this.setContent((NetworkMap)test, false);
            this.viewer.showBackButton(new Runnable(){

                @Override
                public void run() {
                    NetworkMapWidget.this.goBack();
                }
            });
        }
        if (this.viewPart != null && test instanceof Dashboard) {
            try {
                this.viewPart.getSite().getPage().showView("org.netxms.ui.eclipse.dashboard.views.DashboardView", Long.toString(objectId), 1);
            }
            catch (PartInitException e) {
                Shell shell = this.viewPart.getSite().getShell();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.AbstractNetworkMapView_Error, (String)String.format("Cannot open drill-down object view: %s", e.getMessage()));
            }
        }
    }

    private void goBack() {
        if (this.history.isEmpty()) {
            return;
        }
        long submapId = this.history.pop();
        NetworkMap map = (NetworkMap)ConsoleSharedData.getSession().findObjectById(submapId, NetworkMap.class);
        if (map != null) {
            this.setContent(map, false);
        }
        if (this.history.isEmpty()) {
            this.viewer.hideBackButton();
        }
    }

    private void onObjectChange(AbstractObject object) {
        List links;
        if (this.mapPage == null) {
            return;
        }
        NetworkMapObject element = this.mapPage.findObjectElement(object.getObjectId());
        if (element != null) {
            this.viewer.refresh(element, true);
        }
        if ((links = this.mapPage.findLinksWithStatusObject(object.getObjectId())) != null) {
            for (NetworkMapLink l : links) {
                this.viewer.refresh(l);
            }
        }
    }

    public void setContent(NetworkMapPage page) {
        this.mapPage = page;
        this.addDciToRequestList();
        this.viewer.setInput(page);
    }

    public void setContent(NetworkMap mapObject) {
        this.setContent(mapObject, true);
    }

    private void setContent(NetworkMap mapObject, boolean resetHistory) {
        this.syncObjects(mapObject);
        this.currentMapId = mapObject.getObjectId();
        this.setMapLayout(mapObject.getLayout());
        if (mapObject.getBackground() != null && mapObject.getBackground().compareTo(NXCommon.EMPTY_GUID) != 0) {
            if (mapObject.getBackground().equals(NetworkMap.GEOMAP_BACKGROUND)) {
                if (!this.disableGeolocationBackground) {
                    this.viewer.setBackgroundImage(mapObject.getBackgroundLocation(), mapObject.getBackgroundZoom());
                }
            } else {
                this.viewer.setBackgroundImage(ImageProvider.getInstance().getImage(mapObject.getBackground()), mapObject.isCenterBackgroundImage());
            }
        }
        this.setConnectionRouter(mapObject.getDefaultLinkRouting());
        this.viewer.setBackgroundColor(ColorConverter.rgbFromInt((int)mapObject.getBackgroundColor()));
        if (mapObject.getDefaultLinkColor() >= 0) {
            if (this.defaultLinkColor != null) {
                this.defaultLinkColor.dispose();
            }
            this.defaultLinkColor = new Color((Device)this.viewer.getControl().getDisplay(), ColorConverter.rgbFromInt((int)mapObject.getDefaultLinkColor()));
            this.labelProvider.setDefaultLinkColor(this.defaultLinkColor);
        }
        this.labelProvider.setObjectFigureType(mapObject.getObjectDisplayMode());
        this.labelProvider.setShowStatusBackground(mapObject.isShowStatusBackground());
        this.labelProvider.setShowStatusFrame(mapObject.isShowStatusFrame());
        this.labelProvider.setShowStatusIcons(mapObject.isShowStatusIcon());
        this.labelProvider.setTranslucentLabelBackground(mapObject.isTranslucentLabelBackground());
        this.mapPage = mapObject.createMapPage();
        this.addDciToRequestList();
        this.viewer.setInput(this.mapPage);
        if (resetHistory) {
            this.history.clear();
        }
    }

    private void syncObjects(NetworkMap mapObject) {
        NetworkMapPage mapPage = mapObject.createMapPage();
        final List mapObjectIds = mapPage.getObjectIds();
        mapObjectIds.addAll(mapPage.getAllLinkStatusObjects());
        final NXCSession session = ConsoleSharedData.getSession();
        ConsoleJob job = new ConsoleJob(String.format("Sync missing objects for %s netrowk map", mapObject.getObjectName()), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.networkmaps"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.syncMissingObjects(mapObjectIds, true, 2);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).NetworkMapWidget.this.viewer.getControl().isDisposed()) {
                            NetworkMapWidget.this.refresh();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Error synchronizing interface objects";
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setMapLayout(MapLayoutAlgorithm layout) {
        if (layout == MapLayoutAlgorithm.MANUAL) {
            this.viewer.setLayoutAlgorithm(new ManualLayout());
        } else {
            this.setLayoutAlgorithm(layout);
        }
    }

    public void setLayoutAlgorithm(MapLayoutAlgorithm alg) {
        SpringLayoutAlgorithm algorithm;
        switch (alg) {
            case SPRING: {
                algorithm = new SpringLayoutAlgorithm();
                break;
            }
            case RADIAL: {
                algorithm = new RadialLayoutAlgorithm();
                break;
            }
            case HTREE: {
                algorithm = new TreeLayoutAlgorithm(3);
                break;
            }
            case VTREE: {
                algorithm = new TreeLayoutAlgorithm(1);
                break;
            }
            case SPARSE_VTREE: {
                TreeLayoutAlgorithm mainLayoutAlgorithm = new TreeLayoutAlgorithm(1);
                this.viewer.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        return e1.toString().compareToIgnoreCase(e2.toString());
                    }
                });
                algorithm = new CompositeLayoutAlgorithm(new LayoutAlgorithm[]{mainLayoutAlgorithm, new SparseTree()});
                break;
            }
            default: {
                algorithm = new GridLayoutAlgorithm();
            }
        }
        this.viewer.setLayoutAlgorithm((LayoutAlgorithm)algorithm);
    }

    public void setConnectionRouter(int routingAlgorithm) {
        switch (routingAlgorithm) {
            case 2: {
                this.viewer.getGraphControl().setRouter((ConnectionRouter)new ManhattanConnectionRouter());
                break;
            }
            default: {
                this.viewer.getGraphControl().setRouter(null);
            }
        }
        this.viewer.refresh();
    }

    public void zoomTo(double zoomLevel) {
        this.viewer.zoomTo(zoomLevel);
    }

    public void refresh() {
        this.viewer.refresh();
    }

    protected void addDciToRequestList() {
        Collection linkList = this.mapPage.getLinks();
        for (NetworkMapLink item : linkList) {
            if (!item.hasDciData()) continue;
            for (SingleDciConfig value : item.getDciAsList()) {
                if (value.type == 1) {
                    this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                    continue;
                }
                this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
            }
        }
        Collection mapElements = this.mapPage.getElements();
        for (NetworkMapElement element : mapElements) {
            NetworkMapDCIContainer item;
            if (element instanceof NetworkMapDCIContainer && (item = (NetworkMapDCIContainer)element).hasDciData()) {
                SingleDciConfig[] singleDciConfigArray = item.getObjectDCIArray();
                int n = singleDciConfigArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SingleDciConfig value = singleDciConfigArray[n2];
                    if (value.type == 1) {
                        this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                    } else {
                        this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
                    }
                    ++n2;
                }
            }
            if (!(element instanceof NetworkMapDCIImage)) continue;
            item = (NetworkMapDCIImage)element;
            DCIImageConfiguration config = item.getImageOptions();
            SingleDciConfig value = config.getDci();
            if (value.type == 1) {
                this.dciValueProvider.addDci(value.getNodeId(), value.dciId, this.mapPage);
                continue;
            }
            this.dciValueProvider.addDci(value.getNodeId(), value.dciId, value.column, value.instance, this.mapPage);
        }
    }

    public MapLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Control getControl() {
        return this.viewer.getControl();
    }
}

