/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.MessageArea;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class MessageArea
extends Canvas
implements MessageAreaHolder {
    private static final I18n i18n = LocalizationHelper.getI18n(MessageArea.class);
    public static final int INFORMATION = 0;
    public static final int SUCCESS = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    private static final int MAX_ROWS = 4;
    private static final int MARGIN_WIDTH = 4;
    private static final int MARGIN_HEIGHT = 4;
    private static final int MESSAGE_SPACING = 4;
    private static final int TEXT_MARGIN_WIDTH = 5;
    private static final int TEXT_MARGIN_HEIGHT = 5;
    private static Image[] icons = null;
    private static Image iconClose = null;
    private int nextMessageId = 1;
    private List<Message> messages = new ArrayList(0);
    private long messageTimeout = 60000L;
    private Runnable timer = new /* Unavailable Anonymous Inner Class!! */;

    public MessageArea(Composite parent, int style) {
        super(parent, style);
        if (icons == null) {
            icons = new Image[4];
            MessageArea.icons[0] = ResourceManager.getImage((String)"icons/messages/info.png");
            MessageArea.icons[1] = ResourceManager.getImage((String)"icons/messages/success.png");
            MessageArea.icons[2] = ResourceManager.getImage((String)"icons/messages/warning.png");
            MessageArea.icons[3] = ResourceManager.getImage((String)"icons/messages/error.png");
            iconClose = ResourceManager.getImage((String)"icons/messages/close.png");
        }
        this.setBackground(ThemeEngine.getBackgroundColor((String)"MessageArea"));
        GridLayout layout = new GridLayout();
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        layout.verticalSpacing = 4;
        this.setLayout((Layout)layout);
    }

    public int addMessage(int level, String text) {
        return this.addMessage(level, text, false);
    }

    public int addMessage(int level, String text, boolean sticky) {
        if (this.isDisposed()) {
            return -1;
        }
        Message m = new Message(this.nextMessageId++, level, text, sticky);
        if (this.messages.size() >= 4) {
            ((Message)this.messages.get(3)).disposeControl();
        }
        this.messages.add(0, m);
        m.control = new MessageComposite(this, m);
        m.control.moveAbove(null);
        m.control.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.messages.size() == 1) {
            this.getDisplay().timerExec(1000, this.timer);
        }
        this.getParent().layout(true, true);
        return m.id;
    }

    public void deleteMessage(int id) {
        for (int i = 0; i < this.messages.size(); ++i) {
            Message m = (Message)this.messages.get(i);
            if (m.id != id) continue;
            this.messages.remove(i);
            m.disposeControl();
            if (this.messages.size() >= 4) {
                m = (Message)this.messages.get(3);
                m.control = new MessageComposite(this, (Message)this.messages.get(3));
                m.control.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            }
            this.getParent().layout(true, true);
            break;
        }
    }

    public void clearMessages() {
        if (this.messages.isEmpty()) {
            return;
        }
        for (Message m : this.messages) {
            m.disposeControl();
        }
        this.messages.clear();
        this.getParent().layout(true, true);
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    private void onTimer() {
        if (this.isDisposed()) {
            return;
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.messages.size(); ++i) {
            Message m = (Message)this.messages.get(i);
            if (m.sticky || m.timestamp + this.messageTimeout >= now) continue;
            this.deleteMessage(m.id);
            --i;
        }
        if (!this.messages.isEmpty()) {
            this.getDisplay().timerExec(1000, this.timer);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return this.messages.isEmpty() ? new Point(0, 0) : super.computeSize(wHint, hHint, changed);
    }
}

