/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.propertypages;

import java.util.HashMap;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.events.AlarmCategory;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.editors.AlarmCategoryEditor;
import org.netxms.nxmc.modules.alarms.propertypages.AccessControl;
import org.netxms.nxmc.modules.users.views.helpers.BaseUserLabelProvider;
import org.netxms.nxmc.modules.users.views.helpers.UserComparator;
import org.xnap.commons.i18n.I18n;

public class AccessControl
extends PropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(AccessControl.class);
    private SortableTableViewer userList;
    private NXCSession session;
    private AlarmCategory category;
    private AlarmCategoryEditor editor;
    private HashMap<Long, AbstractUserObject> accessMap = new HashMap(0);

    public AccessControl(AlarmCategoryEditor editor) {
        super(i18n.tr("Acces Control"));
        this.editor = editor;
        this.category = editor.getObjectAsItem();
    }

    protected Control createContents(Composite parent) {
        this.session = Registry.getSession();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{i18n.tr("Login Name")};
        int[] columnWidths = new int[]{300};
        this.userList = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new BaseUserLabelProvider());
        this.userList.setComparator((ViewerComparator)new UserComparator());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.userList.getControl().setLayoutData((Object)gd);
        Composite buttons = new Composite(dialogArea, 0);
        FillLayout buttonsLayout = new FillLayout();
        buttonsLayout.spacing = 2;
        buttons.setLayout((Layout)buttonsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 184;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        addButton.setText(i18n.tr("Add..."));
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        deleteButton.setText(i18n.tr("Delete"));
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.userList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        Long[] longArray = this.category.getAccessControl();
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long userId = longArray[i];
            AbstractUserObject user = this.session.findUserDBObjectById(userId, null);
            if (user == null) continue;
            this.accessMap.put(user.getId(), user);
        }
        this.userList.setInput((Object)this.accessMap.values().toArray());
        this.getUsersAndRefresh();
        return dialogArea;
    }

    private void getUsersAndRefresh() {
        if (this.session.isUserDatabaseSynchronized()) {
            return;
        }
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected boolean applyChanges(boolean isApply) {
        Long[] accessControlIds = new Long[this.accessMap.size()];
        int i = 0;
        for (Long id : this.accessMap.keySet()) {
            accessControlIds[i++] = id;
        }
        this.category.setAccessControl(accessControlIds);
        this.editor.modify();
        return true;
    }
}

