/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.dialogs.helpers.ObjectIdMatchingData;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Serializer;

public class AlarmViewerConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=false)
    private int severityFilter = 255;
    @Element(required=false)
    private int stateFilter = 255;
    @Element(required=false)
    private boolean isLocalSoundEnabled = false;

    public static AlarmViewerConfig createFromXml(String xml) throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        return (AlarmViewerConfig)serializer.read(AlarmViewerConfig.class, xml);
    }

    public String createXml() throws Exception {
        Serializer serializer = XMLTools.createSerializer();
        StringWriter writer = new StringWriter();
        serializer.write((Object)this, (Writer)writer);
        return ((Object)writer).toString();
    }

    public Set<Long> getObjects() {
        Set objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public int getSeverityFilter() {
        return this.severityFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }

    public int getStateFilter() {
        return this.stateFilter;
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public boolean getIsLocalSoundEnabled() {
        return this.isLocalSoundEnabled;
    }

    public void setIsLocalSoundEnabled(boolean isLocalSoundEnabled) {
        this.isLocalSoundEnabled = isLocalSoundEnabled;
    }
}

