/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.RackDiagramConfig;
import org.netxms.nxmc.modules.dashboards.config.RackDisplayMode;
import org.netxms.nxmc.modules.dashboards.propertypages.DashboardElementPropertyPage;
import org.netxms.nxmc.modules.dashboards.widgets.TitleConfigurator;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class RackDiagram
extends DashboardElementPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(RackDiagram.class);
    private static final String[] RACK_DISPLAY_MODES = new String[]{i18n.tr("Full"), i18n.tr("Front"), i18n.tr("Back")};
    private RackDiagramConfig config;
    private ObjectSelector objectSelector;
    private TitleConfigurator title;
    private Combo displayMode;

    public RackDiagram(DashboardElementConfig elementConfig) {
        super(i18n.tr("Alarm Viewer"), elementConfig);
    }

    public String getId() {
        return "alarm-viewer";
    }

    public boolean isVisible() {
        return this.elementConfig instanceof RackDiagramConfig;
    }

    public int getPriority() {
        return 0;
    }

    protected Control createContents(Composite parent) {
        this.config = (RackDiagramConfig)this.elementConfig;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.objectSelector = new ObjectSelector(dialogArea, 0, false, true);
        this.objectSelector.setLabel(i18n.tr("Rack"));
        this.objectSelector.setClassFilter(ObjectSelectionDialog.createRackSelectionFilter());
        this.objectSelector.setObjectClass(AbstractObject.class);
        this.objectSelector.setObjectId(this.config.getObjectId());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.objectSelector.setLayoutData((Object)gd);
        this.title = new TitleConfigurator(dialogArea, (DashboardElementConfig)this.config);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.title.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.displayMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)i18n.tr("Display mode"), (Object)gd);
        this.displayMode.setItems(RACK_DISPLAY_MODES);
        this.displayMode.setText(RACK_DISPLAY_MODES[this.config.getDisplayMode().getValue()]);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.title.updateConfiguration((DashboardElementConfig)this.config);
        this.config.setObjectId(this.objectSelector.getObjectId());
        this.config.setDisplayMode(RackDisplayMode.getByValue((int)this.displayMode.getSelectionIndex()));
        return true;
    }
}

