/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.CopyTableRowsAction;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.ObjectDetailsConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.ObjectQuery;
import org.netxms.nxmc.modules.dashboards.widgets.helpers.ObjectDetailsLabelProvider;
import org.netxms.nxmc.modules.dashboards.widgets.helpers.ObjectSelectionProvider;
import org.netxms.nxmc.modules.networkmaps.ObjectDoubleClickHandlerRegistry;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.xnap.commons.i18n.I18n;

public class ObjectQuery
extends ElementWidget {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectQuery.class);
    private ObjectDetailsConfig config;
    private ViewRefreshController refreshController;
    private NXCSession session = Registry.getSession();
    private boolean updateInProgress = false;
    private SortableTableViewer viewer;
    private ObjectSelectionProvider objectSelectionProvider;
    private ObjectDoubleClickHandlerRegistry doubleClickHandlers;
    private Action actionCopyToClipboard;
    private Action actionCopyAllToClipboard;
    private Action actionExportToCSV;
    private Action actionExportAllToCSV;

    public ObjectQuery(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = ObjectDetailsConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new ObjectDetailsConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.viewer = new SortableTableViewer(this.getContentArea(), 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectDetailsLabelProvider(this.config.getProperties()));
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        for (ObjectDetailsConfig.ObjectProperty p : this.config.getProperties()) {
            TableColumn c = this.viewer.addColumn(p.displayName == null || p.displayName.isEmpty() ? p.name : p.displayName, 150);
            c.setData("ObjectProperty", (Object)p);
        }
        this.actionCopyToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, true);
        this.actionCopyToClipboard.setImageDescriptor(SharedIcons.COPY_TO_CLIPBOARD);
        this.actionCopyAllToClipboard = new CopyTableRowsAction((ColumnViewer)this.viewer, false);
        this.actionExportToCSV = new ExportToCsvAction((View)view, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCSV = new ExportToCsvAction((View)view, (ColumnViewer)this.viewer, false);
        this.objectSelectionProvider = new ObjectSelectionProvider((ISelectionProvider)this.viewer);
        this.createContextMenu();
        this.viewer.getControl().addFocusListener((FocusListener)new /* Unavailable Anonymous Inner Class!! */);
        this.doubleClickHandlers = new ObjectDoubleClickHandlerRegistry((View)view);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshController = new ViewRefreshController((View)view, this.config.getRefreshRate(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshData();
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    static long safeParseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    static double safeParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private void createContextMenu() {
        6 menuManager = new /* Unavailable Anonymous Inner Class!! */;
        Menu menu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        7 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }
}

