/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Canvas;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.StatusIndicatorElement;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class StatusIndicatorElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(StatusIndicatorElement.class);
    private final I18n i18n = LocalizationHelper.getI18n(StatusIndicatorElement.class);
    private StatusIndicatorConfig config;
    private Canvas canvas;
    private ViewRefreshController refreshController;
    private Font font;
    private ObjectStatus status = ObjectStatus.UNKNOWN;
    private static final int MARGIN_X = 16;
    private static final int MARGIN_Y = 16;
    private static final int CIRCLE_SIZE = 36;

    protected StatusIndicatorElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = StatusIndicatorConfig.createFromXml((String)element.getData());
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new StatusIndicatorConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.canvas = new /* Unavailable Anonymous Inner Class!! */;
        this.canvas.setBackground(this.colors.create(240, 240, 240));
        this.font = new Font((Device)this.getDisplay(), "Verdana", 12, 0);
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.canvas.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        NXCSession session = Registry.getSession();
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
        this.startRefreshTimer();
    }

    protected void refreshData() {
        NXCSession session = Registry.getSession();
        AbstractObject object = session.findObjectById(this.getEffectiveObjectId(this.config.getObjectId()));
        this.status = object != null ? object.getStatus() : ObjectStatus.UNKNOWN;
        this.canvas.redraw();
    }

    protected void startRefreshTimer() {
        this.refreshController = new ViewRefreshController((View)this.view, 1, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshData();
    }

    public void drawContent(PaintEvent e) {
        e.gc.setAntialias(1);
        if (this.config.isFullColorRange()) {
            e.gc.setBackground(StatusDisplayInfo.getStatusColor((ObjectStatus)this.status));
        } else {
            e.gc.setBackground(this.status == ObjectStatus.NORMAL ? StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL) : StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.CRITICAL));
        }
        e.gc.fillOval(16, 16, 36, 36);
    }
}

