/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.Table;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciSummaryTableColumn;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.modules.dashboards.dialogs.TableColumnSelectionDialog;

public class TableColumnSelector
extends AbstractSelector {
    private String emptySelectionName = "";
    private String columnName = null;
    private DciSummaryTable sourceSummaryTable;
    private Table sourceTable;

    public TableColumnSelector(Composite parent, int style, int options, String columnName, Table sourceTable, DciSummaryTable sourceSummaryTable) {
        super(parent, style, options == 8 ? options : 0);
        this.columnName = columnName;
        this.setText(columnName == null ? this.emptySelectionName : columnName);
        this.sourceTable = sourceTable;
        this.sourceSummaryTable = sourceSummaryTable;
    }

    protected void selectionButtonHandler() {
        String[] columnNames = null;
        if (this.sourceTable != null) {
            columnNames = this.sourceTable.getColumnDisplayNames();
        } else if (this.sourceSummaryTable != null) {
            List columns = this.sourceSummaryTable.getColumns();
            columnNames = new String[columns.size()];
            for (int i = 0; i < columns.size(); ++i) {
                columnNames[i] = ((DciSummaryTableColumn)columns.get(i)).getName();
            }
        }
        TableColumnSelectionDialog dlg = new TableColumnSelectionDialog(this.getShell(), columnNames);
        if (dlg.open() == 0) {
            this.columnName = dlg.getColumnName();
            this.setText(this.columnName == null ? this.emptySelectionName : this.columnName);
            this.fireModifyListeners();
        }
    }

    protected void clearButtonHandler() {
        this.columnName = null;
        this.setText(this.emptySelectionName);
        this.fireModifyListeners();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setSummaryTable(DciSummaryTable sourceSummaryTable) {
        this.sourceSummaryTable = sourceSummaryTable;
    }
}

