/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.TableComparisonChartConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.TableComparisonChartElement;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.xnap.commons.i18n.I18n;

public abstract class TableComparisonChartElement
extends ElementWidget {
    private final I18n i18n = LocalizationHelper.getI18n(TableComparisonChartElement.class);
    protected Chart chart;
    protected NXCSession session;
    protected TableComparisonChartConfig config;
    private ViewRefreshController refreshController;
    private boolean updateInProgress = false;
    private Map<String, Integer> instanceMap = new HashMap(16);
    private boolean chartInitialized = false;

    public TableComparisonChartElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        this.session = Registry.getSession();
        this.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void startRefreshTimer() {
        if (this.config == null || this.config.getDataColumn() == null) {
            return;
        }
        this.refreshController = new ViewRefreshController((View)this.view, this.config.getRefreshRate(), (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshData();
    }

    protected void refreshData() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void updateChart(Table data) {
        String instanceColumn;
        String string = instanceColumn = this.config.getInstanceColumn() != null ? this.config.getInstanceColumn() : "";
        if (instanceColumn == null) {
            return;
        }
        int icIndex = data.getColumnIndex(instanceColumn);
        int dcIndex = data.getColumnIndex(this.config.getDataColumn());
        if (icIndex == -1 || dcIndex == -1) {
            return;
        }
        if (this.config.isSortOnDataColumn()) {
            data.sort((Comparator)new /* Unavailable Anonymous Inner Class!! */);
            this.instanceMap.clear();
            this.chart.removeAllParameters();
        }
        boolean rebuild = false;
        for (int i = 0; i < data.getRowCount(); ++i) {
            double value;
            String instance = data.getCellValue(i, icIndex);
            if (instance == null) continue;
            try {
                value = Double.parseDouble(data.getCellValue(i, dcIndex));
            }
            catch (NumberFormatException e) {
                value = 0.0;
            }
            Integer index = (Integer)this.instanceMap.get(instance);
            if (index == null) {
                if (this.instanceMap.size() >= 16 || value == 0.0 && this.config.isIgnoreZeroValues()) continue;
                index = this.chart.addParameter(new GraphItem(this.config.getNodeId(), this.config.getDciId(), Long.toString(this.config.getDciId()), instance, null, -1, -1));
                this.instanceMap.put(instance, index);
                rebuild = true;
            }
            this.chart.updateParameter(index.intValue(), value, false);
        }
        if (!this.chartInitialized) {
            this.chart.rebuild();
            this.chartInitialized = true;
        } else if (rebuild) {
            this.chart.rebuild();
        } else {
            this.chart.refresh();
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size = super.computeSize(wHint, hHint, changed);
        if (hHint == -1 && size.y < 250) {
            size.y = 250;
        }
        return size;
    }
}

