/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.Arrays;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.Transformation;
import org.netxms.nxmc.modules.nxsl.widgets.ScriptEditor;
import org.netxms.nxmc.tools.WidgetFactory;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class Transformation
extends AbstractDCIPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(Transformation.class);
    private static final String[] DCI_FUNCTIONS = new String[]{"FindDCIByName", "FindDCIByDescription", "GetDCIObject", "GetDCIValue", "GetDCIValueByDescription", "GetDCIValueByName"};
    private static final String[] DCI_VARIABLES = new String[]{"$dci", "$node"};
    private Combo deltaCalculation;
    private ScriptEditor transformationScript;
    private Button testScriptButton;

    public Transformation(DataCollectionObjectEditor editor) {
        super(i18n.tr("Transformation"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.deltaCalculation = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)i18n.tr("Step 1 - delta calculation"), (Object)"WidgetHelper::default_layout_data");
            this.deltaCalculation.add(i18n.tr("None (keep original value)"));
            this.deltaCalculation.add(i18n.tr("Simple delta"));
            this.deltaCalculation.add(i18n.tr("Average delta per second"));
            this.deltaCalculation.add(i18n.tr("Average delta per minute"));
            this.deltaCalculation.select(this.editor.getObjectAsItem().getDeltaCalculation());
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 0;
        gd.heightHint = 0;
        1 factory = new /* Unavailable Anonymous Inner Class!! */;
        this.transformationScript = (ScriptEditor)WidgetHelper.createLabeledControl((Composite)dialogArea, (int)2048, (WidgetFactory)factory, (String)(this.editor.getObject() instanceof DataCollectionItem ? i18n.tr("Step 2 - transformation script") : i18n.tr("Transformation script")), (Object)gd);
        this.transformationScript.addFunctions(Arrays.asList(DCI_FUNCTIONS));
        this.transformationScript.addVariables(Arrays.asList(DCI_VARIABLES));
        this.transformationScript.setText(this.editor.getObject().getTransformationScript());
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.testScriptButton = new Button(this.transformationScript.getParent(), 8);
            this.testScriptButton.setText(i18n.tr("&Test..."));
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            gd.widthHint = 90;
            this.testScriptButton.setLayoutData((Object)gd);
            this.testScriptButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.editor.getObject() instanceof DataCollectionItem) {
            this.editor.getObjectAsItem().setDeltaCalculation(this.deltaCalculation.getSelectionIndex());
        }
        this.editor.getObject().setTransformationScript(this.transformationScript.getText());
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.deltaCalculation != null) {
            this.deltaCalculation.select(0);
        }
        this.transformationScript.setText("");
    }
}

