/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.xnap.commons.i18n.I18n;

public class RuleSourceObjects
extends RuleBasePropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(RuleSourceObjects.class);
    private NXCSession session;
    private SortableTableViewer viewer;
    private Map<Long, AbstractObject> objects = new HashMap();
    private Button addButton;
    private Button deleteButton;
    private Button checkInverted;

    public RuleSourceObjects(RuleEditor editor) {
        super(editor, i18n.tr("Source Objects"));
        this.session = Registry.getSession();
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkInverted = new Button(dialogArea, 32);
        this.checkInverted.setText(i18n.tr("Inverted rule (match objects NOT in the list below)"));
        this.checkInverted.setSelection(this.rule.isSourceInverted());
        String[] columnNames = new String[]{i18n.tr("Objects")};
        int[] columnWidths = new int[]{300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new BaseObjectLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        for (AbstractObject o : this.session.findMultipleObjects((Collection)this.rule.getSources(), true)) {
            this.objects.put(o.getObjectId(), o);
        }
        this.viewer.setInput((Object)this.objects.values().toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(i18n.tr("&Delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        return dialogArea;
    }

    private void addSourceObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            for (AbstractObject o : dlg.getSelectedObjects()) {
                this.objects.put(o.getObjectId(), o);
            }
        }
        this.viewer.setInput((Object)this.objects.values().toArray());
    }

    private void deleteSourceObject() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                AbstractObject o = (AbstractObject)it.next();
                this.objects.remove(o.getObjectId());
            }
            this.viewer.setInput((Object)this.objects.values().toArray());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        int flags = this.rule.getFlags();
        flags = this.checkInverted.getSelection() && !this.objects.isEmpty() ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        this.rule.setFlags(flags);
        this.rule.setSources(new ArrayList(this.objects.keySet()));
        this.editor.setModified(true);
        return true;
    }
}

