/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerAction;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.EventProcessingPolicy;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.actions.views.helpers.BaseActionLabelProvider;
import org.netxms.nxmc.modules.events.views.EventProcessingPolicyEditor;
import org.netxms.nxmc.modules.events.views.helpers.RuleClipboard;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EventProcessingPolicyEditor
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(EventProcessingPolicyEditor.class);
    private NXCSession session;
    private boolean policyLocked = false;
    private EventProcessingPolicy policy;
    private SessionListener sessionListener;
    private Map<Long, ServerAction> actions = new HashMap();
    private String filterText = null;
    private ScrolledComposite scroller;
    private Composite dataArea;
    private List<RuleEditor> ruleEditors = new ArrayList();
    private boolean verticalLayout = false;
    private boolean modified = false;
    private Set<RuleEditor> selection;
    private int lastSelectedRule = -1;
    private RuleClipboard clipboard = new RuleClipboard();
    private BaseObjectLabelProvider objectLabelProvider;
    private BaseActionLabelProvider actionLabelProvider;
    private Font normalFont;
    private Font boldFont;
    private Image imageAlarm;
    private Image imagePersistentStorage;
    private Image imageExecute;
    private Image imageCancelTimer;
    private Image imageTerminate;
    private Image imageStop;
    private Action actionHorizontal;
    private Action actionVertical;
    private Action actionSave;
    private Action actionCollapseAll;
    private Action actionExpandAll;
    private Action actionInsertAbove;
    private Action actionInsertBelow;
    private Action actionCut;
    private Action actionCopy;
    private Action actionPaste;
    private Action actionDelete;
    private Action actionEnableRule;
    private Action actionDisableRule;
    private Action actionAddRule;

    public EventProcessingPolicyEditor() {
        super(i18n.tr("Event Processing Policy"), ResourceManager.getImageDescriptor((String)"icons/config-views/epp-editor.png"), "EPPEditor", true);
        this.session = Registry.getSession();
    }

    public void createContent(Composite parent) {
        this.imageStop = ResourceManager.getImage((String)"icons/epp/stop.png");
        this.imageAlarm = ResourceManager.getImage((String)"icons/alarm.png");
        this.imagePersistentStorage = ResourceManager.getImage((String)"icons/epp/update-pstorage.png");
        this.imageExecute = ResourceManager.getImage((String)"icons/epp/execute.png");
        this.imageCancelTimer = ResourceManager.getImage((String)"icons/epp/cancel-timer.png");
        this.imageTerminate = ResourceManager.getImage((String)"icons/epp/terminate-alarm.png");
        this.objectLabelProvider = new BaseObjectLabelProvider();
        this.actionLabelProvider = new BaseActionLabelProvider();
        this.scroller = new ScrolledComposite(parent, 512);
        this.dataArea = new Composite((Composite)this.scroller, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.dataArea.setLayout((Layout)layout);
        this.dataArea.setBackground(ThemeEngine.getBackgroundColor((String)"RuleEditor"));
        this.scroller.setContent((Control)this.dataArea);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        this.scroller.addControlListener((ControlListener)new /* Unavailable Anonymous Inner Class!! */);
        this.normalFont = JFaceResources.getDefaultFont();
        this.boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.sessionListener);
        this.selection = new TreeSet(new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.openEventProcessingPolicy();
    }

    private void createActions() {
        this.actionHorizontal = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHorizontal.setChecked(!this.verticalLayout);
        this.actionHorizontal.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/epp/h-layout.png"));
        this.actionVertical = new /* Unavailable Anonymous Inner Class!! */;
        this.actionVertical.setChecked(this.verticalLayout);
        this.actionVertical.setImageDescriptor(ResourceManager.getImageDescriptor((String)"icons/epp/v-layout.png"));
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSave.setEnabled(false);
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
        this.actionCollapseAll = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExpandAll = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
        this.actionInsertAbove = new /* Unavailable Anonymous Inner Class!! */;
        this.actionInsertBelow = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCut = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCut.setEnabled(false);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy.setEnabled(false);
        this.actionPaste = new /* Unavailable Anonymous Inner Class!! */;
        this.actionPaste.setEnabled(false);
        this.actionEnableRule = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDisableRule = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddRule = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExpandAll);
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHorizontal);
        manager.add((IAction)this.actionVertical);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddRule);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExpandAll);
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionHorizontal);
        manager.add((IAction)this.actionVertical);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IAction)this.actionDelete);
    }

    private void openEventProcessingPolicy() {
        18 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    private void initPolicyEditor() {
        for (EventProcessingPolicyRule rule : this.policy.getRules()) {
            if (!this.isRuleVisible(rule)) continue;
            RuleEditor editor = new RuleEditor(this.dataArea, rule, this);
            this.ruleEditors.add(editor);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            editor.setLayoutData((Object)gd);
        }
        this.dataArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
    }

    private void updateLayout() {
        for (RuleEditor editor : this.ruleEditors) {
            if (editor.isDisposed()) continue;
            editor.setVerticalLayout(this.verticalLayout, false);
        }
        this.updateEditorAreaLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSessionNotification(SessionNotification n) {
        switch (n.getCode()) {
            case 1006: {
                Map map = this.actions;
                synchronized (map) {
                    this.actions.put(n.getSubCode(), (ServerAction)n.getObject());
                    break;
                }
            }
            case 1007: {
                Map map = this.actions;
                synchronized (map) {
                    this.actions.put(n.getSubCode(), (ServerAction)n.getObject());
                    break;
                }
            }
            case 1008: {
                Map map = this.actions;
                synchronized (map) {
                    this.actions.remove(n.getSubCode());
                    break;
                }
            }
        }
    }

    private void setAllRulesCollapsed(boolean collapsed) {
        for (RuleEditor editor : this.ruleEditors) {
            if (editor.isDisposed()) continue;
            editor.setCollapsed(collapsed, false);
        }
        this.updateEditorAreaLayout();
    }

    public void savePolicy(boolean unlockAfterSave) {
        this.actionSave.setEnabled(false);
        if (unlockAfterSave) {
            this.policyLocked = false;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void dispose() {
        if (this.sessionListener != null) {
            this.session.removeListener(this.sessionListener);
        }
        if (this.policyLocked) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
        this.imageStop.dispose();
        this.imageAlarm.dispose();
        this.imageExecute.dispose();
        this.imageCancelTimer.dispose();
        this.imageTerminate.dispose();
        this.objectLabelProvider.dispose();
        this.actionLabelProvider.dispose();
        this.modified = false;
        super.dispose();
    }

    public void updateEditorAreaLayout() {
        this.dataArea.layout();
        Rectangle r = this.scroller.getClientArea();
        this.scroller.setMinSize(this.dataArea.computeSize(r.width, -1));
    }

    public ServerAction findActionById(Long id) {
        return (ServerAction)this.actions.get(id);
    }

    public Map<Long, ServerAction> findServerActions(List<Long> idList) {
        HashMap<Long, ServerAction> resultSet = new HashMap<Long, ServerAction>();
        for (Long id : idList) {
            ServerAction action = (ServerAction)this.actions.get(id);
            if (action == null) continue;
            resultSet.put(id, action);
        }
        return resultSet;
    }

    public Collection<ServerAction> getActions() {
        return this.actions.values();
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public Font getBoldFont() {
        return this.boldFont;
    }

    public Image getImageAlarm() {
        return this.imageAlarm;
    }

    public Image getImageExecute() {
        return this.imageExecute;
    }

    public Image getImageCancelTimer() {
        return this.imageCancelTimer;
    }

    public Image getImageTerminate() {
        return this.imageTerminate;
    }

    public Image getImageStop() {
        return this.imageStop;
    }

    public Image getImagePersistentStorage() {
        return this.imagePersistentStorage;
    }

    public BaseObjectLabelProvider getObjectLabelProvider() {
        return this.objectLabelProvider;
    }

    public BaseActionLabelProvider getActionLabelProvider() {
        return this.actionLabelProvider;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.actionSave.setEnabled(modified);
    }

    private void clearSelection() {
        for (RuleEditor e : this.selection) {
            e.setSelected(false);
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
    }

    public void setSelection(RuleEditor e) {
        this.clearSelection();
        this.addToSelection(e, false);
    }

    public void onDragDetect(RuleEditor e) {
        if (!this.selection.contains(e)) {
            this.setSelection(e);
        }
    }

    public void addToSelection(RuleEditor e, boolean allFromPrevSelection) {
        if (allFromPrevSelection && this.lastSelectedRule != -1) {
            int direction = Integer.signum(e.getRuleNumber() - this.lastSelectedRule);
            for (int i = this.lastSelectedRule + direction; i != e.getRuleNumber(); i += direction) {
                RuleEditor r = (RuleEditor)this.ruleEditors.get(i - 1);
                this.selection.add(r);
                r.setSelected(true);
            }
        }
        this.selection.add(e);
        e.setSelected(true);
        this.lastSelectedRule = e.getRuleNumber();
        this.onSelectionChange();
    }

    public void removeFromSelection(RuleEditor e) {
        this.selection.remove(e);
        e.setSelected(false);
        this.lastSelectedRule = -1;
        this.onSelectionChange();
    }

    private void onSelectionChange() {
        this.actionDelete.setEnabled(this.selection.size() > 0);
        this.actionInsertAbove.setEnabled(this.selection.size() == 1);
        this.actionInsertBelow.setEnabled(this.selection.size() == 1);
        this.actionCut.setEnabled(this.selection.size() > 0);
        this.actionCopy.setEnabled(this.selection.size() > 0);
        this.actionPaste.setEnabled(this.selection.size() == 1 && !this.clipboard.isEmpty());
    }

    private void deleteSelectedRules() {
        for (RuleEditor e : this.selection) {
            this.policy.deleteRule(e.getRule());
            this.ruleEditors.remove(e);
            e.dispose();
        }
        for (int i = 0; i < this.ruleEditors.size(); ++i) {
            ((RuleEditor)this.ruleEditors.get(i)).setRuleNumber(i + 1);
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
        this.onSelectionChange();
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void insertRule(int position) {
        EventProcessingPolicyRule rule = new EventProcessingPolicyRule();
        rule.setRuleNumber(position + 1);
        this.policy.insertRule(rule, position);
        RuleEditor editor = new RuleEditor(this.dataArea, rule, this);
        this.ruleEditors.add(position, editor);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        editor.setLayoutData((Object)gd);
        for (int i = position + 1; i < this.ruleEditors.size(); ++i) {
            ((RuleEditor)this.ruleEditors.get(i)).setRuleNumber(i + 1);
        }
        if (position < this.ruleEditors.size() - 1) {
            RuleEditor anchor = null;
            for (int i = position + 1; i < this.ruleEditors.size(); ++i) {
                if (((RuleEditor)this.ruleEditors.get(i)).isDisposed()) continue;
                anchor = (RuleEditor)this.ruleEditors.get(i);
                break;
            }
            if (anchor != null) {
                editor.moveAbove(anchor);
            }
        }
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void cutRules() {
        this.clipboard.clear();
        this.actionPaste.setEnabled(true);
        for (RuleEditor e : this.selection) {
            this.clipboard.add(e.getRule());
            this.policy.deleteRule(e.getRule());
            this.ruleEditors.remove(e);
            e.dispose();
        }
        for (int i = 0; i < this.ruleEditors.size(); ++i) {
            ((RuleEditor)this.ruleEditors.get(i)).setRuleNumber(i + 1);
        }
        this.selection.clear();
        this.lastSelectedRule = -1;
        this.onSelectionChange();
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void copyRules() {
        this.clipboard.clear();
        this.actionPaste.setEnabled(true);
        for (RuleEditor e : this.selection) {
            this.clipboard.add(new EventProcessingPolicyRule(e.getRule()));
        }
    }

    private void pasteRules() {
        int position = this.lastSelectedRule;
        RuleEditor anchor = null;
        if (position < this.ruleEditors.size() - 1) {
            for (int i = position; i < this.ruleEditors.size(); ++i) {
                if (((RuleEditor)this.ruleEditors.get(i)).isDisposed()) continue;
                anchor = (RuleEditor)this.ruleEditors.get(i);
                break;
            }
        }
        for (EventProcessingPolicyRule rule : this.clipboard.paste()) {
            rule.setRuleNumber(position + 1);
            this.policy.insertRule(rule, position);
            RuleEditor editor = new RuleEditor(this.dataArea, rule, this);
            this.ruleEditors.add(position, editor);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            editor.setLayoutData((Object)gd);
            if (anchor != null) {
                editor.moveAbove((Control)anchor);
            }
            ++position;
        }
        for (int i = position; i < this.ruleEditors.size(); ++i) {
            ((RuleEditor)this.ruleEditors.get(i)).setRuleNumber(i + 1);
        }
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    public void moveSelection(RuleEditor anchor) {
        if (this.selection.contains(anchor)) {
            return;
        }
        ArrayList<RuleEditor> movedRuleEditors = new ArrayList<RuleEditor>();
        for (RuleEditor e : this.ruleEditors) {
            if (this.selection.contains(e)) continue;
            movedRuleEditors.add(e);
            if (!e.equals(anchor)) continue;
            RuleEditor curr = anchor;
            for (RuleEditor s : this.selection) {
                movedRuleEditors.add(s);
                s.moveBelow((Control)curr);
                curr = s;
            }
        }
        this.policy = new EventProcessingPolicy(movedRuleEditors.size());
        int i = 0;
        for (RuleEditor e : movedRuleEditors) {
            this.policy.addRule(e.getRule());
            e.setRuleNumber(++i);
        }
        this.ruleEditors = movedRuleEditors;
        this.updateEditorAreaLayout();
        this.setModified(true);
    }

    private void enableRules(boolean enabled) {
        for (RuleEditor e : this.selection) {
            e.enableRule(enabled);
        }
    }

    public void fillRuleContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionEnableRule);
        manager.add((IAction)this.actionDisableRule);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionInsertAbove);
        manager.add((IAction)this.actionInsertBelow);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCut);
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionPaste);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDelete);
    }

    protected void onFilterModify() {
        this.filterText = this.getFilterText().trim().toLowerCase();
        RuleEditor prev = null;
        for (int i = 0; i < this.ruleEditors.size(); ++i) {
            RuleEditor e = (RuleEditor)this.ruleEditors.get(i);
            boolean visible = this.isRuleVisible(e.getRule());
            if (!e.isDisposed() && !visible) {
                e.dispose();
                this.selection.remove(e);
            } else if (e.isDisposed() && visible) {
                e = new RuleEditor(this.dataArea, e.getRule(), this);
                GridData gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                e.setLayoutData((Object)gd);
                if (prev != null) {
                    e.moveBelow((Control)prev);
                } else {
                    e.moveAbove(null);
                }
                this.ruleEditors.set(i, e);
            }
            if (e.isDisposed()) continue;
            prev = e;
        }
        this.updateEditorAreaLayout();
    }

    private boolean isRuleVisible(EventProcessingPolicyRule rule) {
        if (this.filterText == null || this.filterText.isEmpty()) {
            return true;
        }
        if (rule.getComments().toLowerCase().contains(this.filterText)) {
            return true;
        }
        for (Long code : rule.getEvents()) {
            EventTemplate evt = this.session.findEventTemplateByCode(code.longValue());
            if (evt == null || !evt.getName().toLowerCase().contains(this.filterText)) continue;
            return true;
        }
        for (Long id : rule.getSources()) {
            String name = this.session.getObjectName(id.longValue());
            if (name == null || !name.toLowerCase().contains(this.filterText)) continue;
            return true;
        }
        return false;
    }

    public void save() {
        this.savePolicy(true);
    }
}

