/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.SyslogRecord;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class SyslogLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color FOREGROUND_COLOR_DARK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color FOREGROUND_COLOR_LIGHT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color[] FOREGROUND_COLORS = new Color[]{FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_LIGHT};
    private static final Severity[] severityMap = new Severity[]{Severity.CRITICAL, Severity.CRITICAL, Severity.MAJOR, Severity.MINOR, Severity.WARNING, Severity.WARNING, Severity.NORMAL, Severity.NORMAL};
    private final I18n i18n = LocalizationHelper.getI18n(SyslogLabelProvider.class);
    private final String[] severityText = new String[]{this.i18n.tr("Emergency"), this.i18n.tr("Alert"), this.i18n.tr("Critical"), this.i18n.tr("Error"), this.i18n.tr("Warning"), this.i18n.tr("Notice"), this.i18n.tr("Info"), this.i18n.tr("Debug")};
    private final String[] facilityText = new String[]{this.i18n.tr("Kernel"), this.i18n.tr("User"), this.i18n.tr("Mail"), this.i18n.tr("System"), this.i18n.tr("Auth"), this.i18n.tr("Syslog"), this.i18n.tr("Lpr"), this.i18n.tr("News"), this.i18n.tr("UUCP"), this.i18n.tr("Cron"), this.i18n.tr("Security"), this.i18n.tr("FTPD"), this.i18n.tr("NTP"), this.i18n.tr("Log Audit"), this.i18n.tr("Log Alert"), this.i18n.tr("Clock"), this.i18n.tr("Local0"), this.i18n.tr("Local1"), this.i18n.tr("Local2"), this.i18n.tr("Local3"), this.i18n.tr("Local4"), this.i18n.tr("Local5"), this.i18n.tr("Local6"), this.i18n.tr("Local7")};
    private NXCSession session = Registry.getSession();
    private boolean showColor = true;
    private boolean showIcons = false;

    public Color getForeground(Object element) {
        return this.showColor ? FOREGROUND_COLORS[severityMap[((SyslogRecord)element).getSeverity()].getValue()] : null;
    }

    public Color getBackground(Object element) {
        return this.showColor ? StatusDisplayInfo.getStatusColor((Severity)severityMap[((SyslogRecord)element).getSeverity()]) : null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.showIcons && columnIndex == 0) {
            return StatusDisplayInfo.getStatusImage((Severity)severityMap[((SyslogRecord)element).getSeverity()]);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SyslogRecord record = (SyslogRecord)element;
        switch (columnIndex) {
            case 0: {
                return DateFormatFactory.getDateTimeFormat().format(record.getTimestamp());
            }
            case 1: {
                AbstractObject object = this.session.findObjectById(record.getSourceObjectId());
                return object != null ? object.getObjectName() : this.i18n.tr("<unknown>");
            }
            case 2: {
                try {
                    return this.severityText[record.getSeverity()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return "<" + Integer.toString(record.getSeverity()) + ">";
                }
            }
            case 3: {
                try {
                    return this.facilityText[record.getFacility()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return "<" + Integer.toString(record.getFacility()) + ">";
                }
            }
            case 6: {
                return record.getMessage();
            }
            case 5: {
                return record.getTag();
            }
            case 4: {
                return record.getHostname();
            }
        }
        return null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public void setShowColor(boolean showColor) {
        this.showColor = showColor;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
    }
}

