/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerEditor;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.mt.MappingTable;
import org.netxms.client.mt.MappingTableEntry;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.nxsl.views.MappingTableEditorView;
import org.netxms.nxmc.modules.nxsl.views.helpers.MappingTableEntryLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class MappingTableEditorView
extends ConfigurationView {
    public static final int COLUMN_KEY = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private final I18n i18n = LocalizationHelper.getI18n(MappingTableEditorView.class);
    private int mappingTableId;
    private MappingTable mappingTable;
    private NXCSession session;
    private GridTableViewer viewer;
    private boolean modified = false;
    private Action actionNewRow;
    private Action actionDelete;
    private Action actionSave;

    public MappingTableEditorView(int mappingTableId, String mappingTableName) {
        super(mappingTableName, ResourceManager.getImageDescriptor((String)"icons/config-views/script-editor.png"), "MappingTableEditor." + Integer.toString(mappingTableId), false);
        this.mappingTableId = mappingTableId;
        this.session = Registry.getSession();
    }

    protected void createContent(Composite parent) {
        this.viewer = new GridTableViewer(parent, 768);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MappingTableEntryLabelProvider());
        Grid grid = this.viewer.getGrid();
        grid.setHeaderVisible(true);
        grid.setCellSelectionEnabled(true);
        GridColumn column = new GridColumn(grid, 0);
        column.setText(this.i18n.tr("Key"));
        column.setWidth(200);
        column = new GridColumn(grid, 0);
        column.setText(this.i18n.tr("Value"));
        column.setWidth(200);
        column = new GridColumn(grid, 0);
        column.setText(this.i18n.tr("Comments"));
        column.setWidth(400);
        this.viewer.setColumnProperties(new String[]{"key", "value", "comments"});
        CellEditor[] editors = new CellEditor[]{new MappingTableCellEditor((Composite)this.viewer.getGrid()), new MappingTableCellEditor((Composite)this.viewer.getGrid()), new MappingTableCellEditor((Composite)this.viewer.getGrid())};
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier((ICellModifier)new CellModifier(this));
        1 activationStrategy = new /* Unavailable Anonymous Inner Class!! */;
        GridViewerEditor.create((GridTableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)58);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
    }

    protected void postContentCreate() {
        this.refresh();
    }

    private void createActions() {
        this.actionNewRow = new /* Unavailable Anonymous Inner Class!! */;
        this.actionNewRow.setEnabled(false);
        this.addKeyBinding("M1+N", (IAction)this.actionNewRow);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
        this.actionSave = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSave.setEnabled(false);
        this.addKeyBinding("M1+S", (IAction)this.actionSave);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionSave);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionSave);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionDelete);
    }

    public void setFocus() {
        this.viewer.getGrid().setFocus();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void save() {
        MappingTable t = new MappingTable(this.mappingTable);
        t.getData().remove(t.getData().size() - 1);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void refresh() {
        if (this.modified && !MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Reload Content"), (String)this.i18n.tr("Any unsaved changes will be lost. Are you sure?"))) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void setModified(boolean m) {
        if (this.modified == m) {
            return;
        }
        this.modified = m;
        this.actionSave.setEnabled(m);
    }

    private void addNewRow() {
        if (this.mappingTable == null) {
            return;
        }
        MappingTableEntry e = (MappingTableEntry)this.mappingTable.getData().get(this.mappingTable.getData().size() - 1);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)e));
        this.viewer.editElement((Object)e, 0);
    }

    private void deleteRows() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        for (Object o : selection.toList()) {
            this.mappingTable.getData().remove(o);
        }
        this.viewer.refresh();
        this.setModified(true);
    }
}

