/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.nxsl.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.dialogs.KeyValuePairEditDialog;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.base.widgets.helpers.KeyValuePairFilter;
import org.netxms.nxmc.base.widgets.helpers.KeyValuePairLabelProvider;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.xnap.commons.i18n.I18n;

public class PersistentStorageView
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(PersistentStorageView.class);
    private NXCSession session;
    private SortableTableViewer viewer;
    private Action actionCreate;
    private Action actionEdit;
    private Action actionDelete;
    private Map<String, String> pStorageSet = new HashMap();

    public PersistentStorageView() {
        super(i18n.tr("Persistent Storage"), ResourceManager.getImageDescriptor((String)"icons/config-views/persistent-storage.png"), "PersistentStorage", true);
        this.session = Registry.getSession();
    }

    public void createContent(Composite parent) {
        String[] setColumnNames = new String[]{i18n.tr("Key"), i18n.tr("Value")};
        int[] setColumnWidths = new int[]{200, 400};
        this.viewer = new SortableTableViewer(parent, setColumnNames, setColumnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new KeyValuePairLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        KeyValuePairFilter filter = new KeyValuePairFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.createActions();
        this.createPopupMenu();
    }

    protected void postContentCreate() {
        this.refresh();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionEdit);
        }
        if (selection.size() > 0) {
            mgr.add((IAction)this.actionDelete);
        }
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionCreate);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreate);
    }

    private void createActions() {
        this.actionCreate = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionCreate);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M3+ENTER", (IAction)this.actionEdit);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createValue() {
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getWindow().getShell(), null, null, true, true);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteValue() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object o : selection.toList()) {
            keys.add((String)((Map.Entry)o).getKey());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editValue() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        Map.Entry attr = (Map.Entry)selection.getFirstElement();
        KeyValuePairEditDialog dlg = new KeyValuePairEditDialog(this.getWindow().getShell(), (String)attr.getKey(), (String)attr.getValue(), true, false);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

