/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.InputField;
import org.netxms.client.constants.InputFieldType;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class InputFieldEditDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(InputFieldEditDialog.class);
    private final String[] typeNames = new String[]{this.i18n.tr("Text"), this.i18n.tr("Password"), this.i18n.tr("Number")};
    private boolean create;
    private InputField field;
    private LabeledText name;
    private Combo type;
    private LabeledText displayName;
    private Button checkValidatePassword;

    public InputFieldEditDialog(Shell parentShell, boolean create, InputField field) {
        super(parentShell);
        this.create = create;
        this.field = field;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.create ? this.i18n.tr("Add Input Field") : this.i18n.tr("Edit Input Field"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(this.i18n.tr("Name"));
        this.name.setText(this.field.getName());
        this.name.setEditable(this.create);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.name.setLayoutData((Object)gd);
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Type"), (Object)"WidgetHelper::default_layout_data");
        for (int i = 0; i < this.typeNames.length; ++i) {
            this.type.add(this.typeNames[i]);
        }
        this.type.select(this.field.getType().getValue());
        this.type.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.displayName = new LabeledText(dialogArea, 0);
        this.displayName.setLabel(this.i18n.tr("Display name"));
        this.displayName.setText(this.field.getDisplayName());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.displayName.setLayoutData((Object)gd);
        this.checkValidatePassword = new Button(dialogArea, 32);
        this.checkValidatePassword.setText(this.i18n.tr("Validate password after entry"));
        this.checkValidatePassword.setVisible(this.field.getType() == InputFieldType.PASSWORD);
        this.checkValidatePassword.setSelection(this.field.isPasswordValidationNeeded());
        return dialogArea;
    }

    protected void okPressed() {
        if (this.create) {
            this.field.setName(this.name.getText());
        }
        this.field.setType(InputFieldType.getByValue((int)this.type.getSelectionIndex()));
        this.field.setDisplayName(this.displayName.getText());
        if (this.field.getType() == InputFieldType.PASSWORD) {
            int flags = this.field.getFlags();
            flags = this.checkValidatePassword.getSelection() ? (flags |= 1) : (flags &= 0xFFFFFFFE);
            this.field.setFlags(flags);
        }
        super.okPressed();
    }
}

