/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCompressionMode;
import org.netxms.client.constants.CertificateMappingMethod;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.PasswordInputField;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class Agent
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(Agent.class);
    private AbstractNode node;
    private LabeledText agentPort;
    private PasswordInputField agentSharedSecret;
    private Button agentForceEncryption;
    private Button agentTunnelOnly;
    private ObjectSelector agentProxy;
    private Button radioAgentCompressionDefault;
    private Button radioAgentCompressionEnabled;
    private Button radioAgentCompressionDisabled;
    private Combo certMappingMethod;
    private LabeledText certMappingData;

    public Agent(AbstractObject object) {
        super(i18n.tr("Agent"), object);
    }

    public String getId() {
        return "communication.agent";
    }

    public String getParentId() {
        return "communication";
    }

    public boolean isVisible() {
        return this.object instanceof AbstractNode;
    }

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.object;
        Composite dialogArea = new Composite(parent, 0);
        FormLayout dialogLayout = new FormLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.spacing = 5;
        dialogArea.setLayout((Layout)dialogLayout);
        this.agentPort = new LabeledText(dialogArea, 0);
        this.agentPort.setLabel(i18n.tr("TCP port"));
        this.agentPort.setText(Integer.toString(this.node.getAgentPort()));
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        this.agentPort.setLayoutData((Object)fd);
        this.agentProxy = new ObjectSelector(dialogArea, 0, true);
        this.agentProxy.setLabel(i18n.tr("Proxy"));
        this.agentProxy.setObjectId(this.node.getAgentProxyId());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.agentPort, 0, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.agentProxy.setLayoutData((Object)fd);
        this.agentForceEncryption = new Button(dialogArea, 32);
        this.agentForceEncryption.setText(i18n.tr("Force encryption"));
        this.agentForceEncryption.setSelection((this.node.getFlags() & 0x400000) != 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.agentPort, 0, 1024);
        this.agentForceEncryption.setLayoutData((Object)fd);
        this.agentTunnelOnly = new Button(dialogArea, 32);
        this.agentTunnelOnly.setText(i18n.tr("Agent connections through &tunnel only"));
        this.agentTunnelOnly.setSelection((this.node.getFlags() & 0x1000000) != 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.agentForceEncryption, 0, 1024);
        this.agentTunnelOnly.setLayoutData((Object)fd);
        this.agentSharedSecret = new PasswordInputField(dialogArea, 0);
        this.agentSharedSecret.setLabel(i18n.tr("Shared secret"));
        this.agentSharedSecret.setText(this.node.getAgentSharedSecret());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.agentTunnelOnly, 0, 1024);
        this.agentSharedSecret.setLayoutData((Object)fd);
        Group agentCompressionGroup = new Group(dialogArea, 0);
        agentCompressionGroup.setText(i18n.tr("Protocol compression mode"));
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        agentCompressionGroup.setLayout((Layout)layout);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.agentSharedSecret, 0, 1024);
        agentCompressionGroup.setLayoutData((Object)fd);
        this.radioAgentCompressionDefault = new Button((Composite)agentCompressionGroup, 16);
        this.radioAgentCompressionDefault.setText("Default");
        this.radioAgentCompressionDefault.setSelection(this.node.getAgentCompressionMode() == AgentCompressionMode.DEFAULT);
        this.radioAgentCompressionEnabled = new Button((Composite)agentCompressionGroup, 16);
        this.radioAgentCompressionEnabled.setText("Enabled");
        this.radioAgentCompressionEnabled.setSelection(this.node.getAgentCompressionMode() == AgentCompressionMode.ENABLED);
        this.radioAgentCompressionDisabled = new Button((Composite)agentCompressionGroup, 16);
        this.radioAgentCompressionDisabled.setText("Disabled");
        this.radioAgentCompressionDisabled.setSelection(this.node.getAgentCompressionMode() == AgentCompressionMode.DISABLED);
        Group certificateMappingGroup = new Group(dialogArea, 0);
        certificateMappingGroup.setText(i18n.tr("Certificate mapping"));
        layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.numColumns = 2;
        certificateMappingGroup.setLayout((Layout)layout);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)agentCompressionGroup, 0, 1024);
        certificateMappingGroup.setLayoutData((Object)fd);
        this.certMappingMethod = WidgetHelper.createLabeledCombo((Composite)certificateMappingGroup, (int)12, (String)i18n.tr("Method"), (Object)new GridData(4, 1024, false, false));
        this.certMappingMethod.add("Subject");
        this.certMappingMethod.add("Public key");
        this.certMappingMethod.add("Common name");
        this.certMappingMethod.add("Template ID");
        this.certMappingMethod.select(this.node.getAgentCertificateMappingMethod().getValue());
        this.certMappingData = new LabeledText((Composite)certificateMappingGroup, 0);
        this.certMappingData.setLabel(i18n.tr("Mapping data"));
        if (this.node.getAgentCertificateMappingData() != null) {
            this.certMappingData.setText(this.node.getAgentCertificateMappingData());
        }
        this.certMappingData.setLayoutData((Object)new GridData(4, 1024, true, false));
        return dialogArea;
    }

    private AgentCompressionMode collectAgentCompressionMode() {
        if (this.radioAgentCompressionEnabled.getSelection()) {
            return AgentCompressionMode.ENABLED;
        }
        if (this.radioAgentCompressionDisabled.getSelection()) {
            return AgentCompressionMode.DISABLED;
        }
        return AgentCompressionMode.DEFAULT;
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        try {
            md.setAgentPort(Integer.parseInt(this.agentPort.getText(), 10));
        }
        catch (NumberFormatException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)i18n.tr("Warning"), (String)i18n.tr("Please enter valid agent port number"));
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        md.setAgentProxy(this.agentProxy.getObjectId());
        md.setAgentSecret(this.agentSharedSecret.getText().trim());
        md.setAgentCompressionMode(this.collectAgentCompressionMode());
        md.setObjectFlags((this.agentForceEncryption.getSelection() ? 0x400000 : 0) | (this.agentTunnelOnly.getSelection() ? 0x1000000 : 0), 0x1400000);
        md.setCertificateMapping(CertificateMappingMethod.getByValue((int)this.certMappingMethod.getSelectionIndex()), this.certMappingData.getText().trim());
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.agentPort.setText("4700");
        this.agentForceEncryption.setSelection(false);
        this.agentProxy.setObjectId(0L);
        this.agentSharedSecret.setText("");
        this.certMappingMethod.select(CertificateMappingMethod.COMMON_NAME.getValue());
        this.certMappingData.setText("");
    }
}

